CREATE OR REPLACE FUNCTION is_valid_year(year text) RETURNS boolean AS $$
DECLARE
	tmp date;
BEGIN
	IF year IS NULL THEN RETURN false; END IF;
	tmp := CAST(concat(year,'-01-01') AS date);
	return true;
	
	EXCEPTION 
		WHEN OTHERS THEN RETURN false;
END;
$$ LANGUAGE plpgsql;