/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.sdmx.model;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.data.analysis.sdmx.model.TableIdentificators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TableAssociationResource {
    private GenericResource tableAssociationResource;
    private Map<String, TableIdentificators> associationsTable;
    private Logger logger = LoggerFactory.getLogger(TableAssociationResource.class);
    private boolean associationsModified;
    private final String RECORD_ELEMENT = "record";
    private final String DATAFLOW_ELEMENT = "dataflow";
    private final String TABLE_ELEMENT = "table";
    private final String TABLULAR_RESOURCE_ELEMENT = "tablularresource";
    private final String TIMEDIMENSION_ELEMENT = "timedimension";
    private final String PRIMARYMEASURE_ELEMENT = "primaryMeasure";
    private final String ASSOCIATIONS_ELEMENT = "associations";

    public TableAssociationResource(String name) {
        this.tableAssociationResource = (GenericResource)Resources.unmarshal(GenericResource.class, (InputStream)this.getClass().getResourceAsStream("/sdmxresourcemodel.xml"));
        this.tableAssociationResource.profile().name(name);
        this.associationsTable = new HashMap<String, TableIdentificators>();
        this.associationsModified = false;
    }

    public TableAssociationResource(String name, Map<String, TableIdentificators> associationsTable) {
        this.tableAssociationResource = (GenericResource)Resources.unmarshal(GenericResource.class, (InputStream)this.getClass().getResourceAsStream("/sdmxresourcemodel.xml"));
        this.tableAssociationResource.profile().name(name);
        this.associationsTable = associationsTable;
        this.associationsModified = true;
    }

    public TableAssociationResource(GenericResource tableAssociation) {
        this.tableAssociationResource = tableAssociation;
        this.associationsTable = this.getAssociatons(tableAssociation.profile().body());
        this.associationsModified = false;
    }

    public GenericResource getGenericResurce() {
        if (this.associationsModified) {
            this.updateResource(this.associationsTable);
        }
        return this.tableAssociationResource;
    }

    public void addAssociation(String flowId, String tabularResourceId, String tableId, String timeDimension, String primaryMeasure) {
        this.associationsTable.put(flowId, new TableIdentificators(tabularResourceId, tableId, timeDimension, primaryMeasure));
        this.associationsModified = true;
    }

    public void removeAssociation(String flowId) {
        this.associationsTable.remove(flowId);
        this.associationsModified = true;
    }

    public Map<String, TableIdentificators> getAssociationsTable() {
        return this.associationsTable;
    }

    private void updateResource(Map<String, TableIdentificators> associations) {
        this.logger.debug("Updating generic element");
        this.logger.debug("Original body " + this.tableAssociationResource.profile().bodyAsString());
        try {
            Element bodyElement = this.tableAssociationResource.profile().newBody();
            Document document = bodyElement.getOwnerDocument();
            Element associationsElement = document.createElement("associations");
            bodyElement.appendChild(associationsElement);
            Set<String> dataFlowSet = associations.keySet();
            for (String dataFlow : dataFlowSet) {
                this.logger.debug("Generating new record");
                Element recordElement = document.createElement("record");
                associationsElement.appendChild(recordElement);
                TableIdentificators tableIdentificators = associations.get(dataFlow);
                this.logger.debug("Adding data flow " + dataFlow + " table " + tableIdentificators);
                this.appendStringElement(document, recordElement, "dataflow", dataFlow);
                String tableId = tableIdentificators.getTableIDString();
                this.logger.debug("Adding table element " + tableId);
                this.appendStringElement(document, recordElement, "table", tableId);
                String tabularResourceID = tableIdentificators.getTabularResourceIDString();
                this.logger.debug("Adding tabular resource id  element " + tabularResourceID);
                this.appendStringElement(document, recordElement, "tablularresource", tabularResourceID);
                String timeDimension = tableIdentificators.getTimeDimension();
                this.logger.debug("Adding tabular time dimension  element " + tabularResourceID);
                this.appendStringElement(document, recordElement, "timedimension", timeDimension);
                String primaryMeasure = tableIdentificators.getPrimaryMeasure();
                this.logger.debug("Adding tabular primary measure  element " + primaryMeasure);
                this.appendStringElement(document, recordElement, "primaryMeasure", primaryMeasure);
                this.logger.debug("Record generated, new body " + this.tableAssociationResource.profile().bodyAsString());
            }
            this.associationsModified = false;
        }
        catch (Exception e) {
            this.logger.error("Unable to update Generic Resource");
        }
    }

    private void appendStringElement(Document originalDocument, Element rootElement, String elementName, String elementValue) {
        Element newElement = originalDocument.createElement(elementName);
        Text newElementTextNode = originalDocument.createTextNode(elementValue);
        newElement.appendChild(newElementTextNode);
        rootElement.appendChild(newElement);
    }

    private HashMap<String, TableIdentificators> getAssociatons(Element body) {
        this.logger.debug("Parsing result " + body.getLocalName());
        NodeList nodes = body.getElementsByTagName("record");
        HashMap<String, TableIdentificators> response = new HashMap<String, TableIdentificators>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element recordElement = (Element)nodes.item(i);
            this.logger.debug("Parsing record element " + (i + 1));
            NodeList dataFlowElements = recordElement.getElementsByTagName("dataflow");
            NodeList tableElements = recordElement.getElementsByTagName("table");
            NodeList tabularResourceElements = recordElement.getElementsByTagName("tablularresource");
            NodeList timeDimensionElements = recordElement.getElementsByTagName("timedimension");
            NodeList primaryMeasureElements = recordElement.getElementsByTagName("primaryMeasure");
            if (dataFlowElements.getLength() == 0 || tableElements.getLength() == 0 || tabularResourceElements.getLength() == 0) {
                this.logger.warn("Invalid element");
                continue;
            }
            String flowId = this.getSingleValue(dataFlowElements);
            this.logger.debug("Flow ID " + flowId);
            String tableId = this.getSingleValue(tableElements);
            this.logger.debug("Table ID " + tableId);
            String tablularResourceId = this.getSingleValue(tabularResourceElements);
            this.logger.debug("Tablular Resource ID " + tablularResourceId);
            String timeDimension = this.getSingleValue(timeDimensionElements);
            this.logger.debug("Time dimension " + timeDimension);
            String primaryMeasure = this.getSingleValue(primaryMeasureElements);
            this.logger.debug("Primary Measure " + primaryMeasure);
            response.put(flowId, new TableIdentificators(tablularResourceId, tableId, timeDimension, primaryMeasure));
        }
        return response;
    }

    private String getSingleValue(NodeList source) {
        Node singleNodeNode = source.item(0);
        String nodeValue = singleNodeNode.getFirstChild().getNodeValue();
        this.logger.debug("Single Value " + nodeValue);
        return nodeValue;
    }
}

