/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.persistence.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.data.analysis.statisticalmanager.Configuration;
import org.gcube.data.analysis.statisticalmanager.exception.AlgorithmManagementException;
import org.gcube.data.analysis.statisticalmanager.experimentspace.AlgorithmCategory;
import org.gcube.data.analysis.statisticalmanager.experimentspace.FactoryComputationParameter;
import org.gcube.data.analysis.statisticalmanager.persistence.algorithms.AlgorithmCategoryDescriptor;
import org.gcube.data.analysis.statisticalmanager.persistence.algorithms.AlgorithmDescriptor;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.SMGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMListGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.SMTypeParameter;
import org.gcube.data.analysis.statisticalmanager.util.ScopeUtils;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.processing.factories.ClusterersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.EvaluatorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ModelersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ProcessorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.StatisticalServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgorithmManager {
    private static Logger logger = LoggerFactory.getLogger(AlgorithmManager.class);
    private static String configPath = null;
    private static Map<AlgorithmCategory, AlgorithmCategoryDescriptor> staticallyLoadedAlgorithms = new LinkedHashMap<AlgorithmCategory, AlgorithmCategoryDescriptor>();
    private static Map<String, List<String>> foundAlgorithms = null;
    private static Map<String, List<String>> userPerspectiveMap;

    public static synchronized void initInstalledAlgorithms(String toSetConfigPath, boolean skipErrors) throws AlgorithmManagementException {
        block13: {
            try {
                if (configPath != null) break block13;
                configPath = toSetConfigPath;
                logger.trace("Initializing Algorithms, config path is " + configPath);
                AnalysisLogger.setLogger((String)(String.valueOf(configPath) + AlgorithmConfiguration.defaultLoggerFile));
                logger.trace("Loading installed algorithms, config path is " + configPath);
                AlgorithmConfiguration algoConfig = AlgorithmManager.setUpBuildWPS(configPath);
                foundAlgorithms = ProcessorsFactory.getAllFeatures((AlgorithmConfiguration)algoConfig);
                for (Map.Entry<String, List<String>> entry : foundAlgorithms.entrySet()) {
                    try {
                        AlgorithmCategory category = AlgorithmCategory.valueOf(entry.getKey());
                        LinkedHashSet<AlgorithmDescriptor> descriptors = new LinkedHashSet<AlgorithmDescriptor>();
                        for (String algorithmName : entry.getValue()) {
                            try {
                                descriptors.add(AlgorithmManager.getAlgorithmDescriptor(category, algorithmName, algoConfig));
                            }
                            catch (Exception e) {
                                if (!skipErrors) {
                                    throw new AlgorithmManagementException(e);
                                }
                                logger.warn("Unable to load algorithm " + algorithmName, (Throwable)e);
                            }
                            logger.debug("Loaded " + descriptors.size() + " " + (Object)((Object)category) + " algorithms");
                        }
                        if (descriptors.isEmpty()) continue;
                        staticallyLoadedAlgorithms.put(category, new AlgorithmCategoryDescriptor(category, descriptors));
                    }
                    catch (IllegalArgumentException e) {
                        logger.trace("Skipped invalid algorithm category " + entry.getKey());
                    }
                }
                logger.trace("Loading user perspective");
                userPerspectiveMap = ProcessorsFactory.getAllFeaturesUser((AlgorithmConfiguration)algoConfig);
                for (Map.Entry<String, List<String>> perspectiveEntry : userPerspectiveMap.entrySet()) {
                    for (String algorithmName : perspectiveEntry.getValue()) {
                        AlgorithmManager.getAlgorithmByNameInMap(staticallyLoadedAlgorithms, algorithmName).getUserPerspectiveCategory().add(perspectiveEntry.getKey());
                    }
                }
            }
            catch (AlgorithmManagementException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AlgorithmManagementException(e);
            }
        }
        logger.trace("Loaded Algorithms : ");
        for (AlgorithmCategoryDescriptor categoryDesc : staticallyLoadedAlgorithms.values()) {
            logger.trace(categoryDesc.toString());
        }
    }

    public static String getConfigPath() {
        return configPath;
    }

    public static AlgorithmDescriptor getAlgorithmByName(String name) throws AlgorithmManagementException {
        return AlgorithmManager.getAlgorithmByNameInMap(AlgorithmManager.getInstalledAlgorithms(), name);
    }

    private static AlgorithmDescriptor getAlgorithmByNameInMap(Map<AlgorithmCategory, AlgorithmCategoryDescriptor> toLookInto, String algorithmName) throws AlgorithmManagementException {
        for (AlgorithmCategoryDescriptor category : toLookInto.values()) {
            if (!category.containsAlgorithm(algorithmName)) continue;
            return category.getAlgorithmDescriptor(algorithmName);
        }
        throw new AlgorithmManagementException("Unknown algorithm " + algorithmName);
    }

    private static Map<AlgorithmCategory, Set<String>> getInScope() {
        logger.debug("Getting Algorithms under scope " + ScopeUtils.getCurrentScope());
        LinkedHashMap<AlgorithmCategory, Set<String>> toReturn = new LinkedHashMap<AlgorithmCategory, Set<String>>();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType eq '" + Configuration.getProperty("GR_SECONDARY_TYPE") + "'");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        for (GenericResource genRes : client.submit((Query)query)) {
            try {
                AlgorithmCategory category = AlgorithmCategory.valueOf(genRes.profile().body().getElementsByTagName("category").item(0).getTextContent());
                if (!toReturn.containsKey((Object)category)) {
                    toReturn.put(category, new LinkedHashSet());
                }
                toReturn.get((Object)category).add(genRes.profile().name());
            }
            catch (Exception e) {
                logger.warn("Unable to load algorithm from Generic Resource [name : {}, id {}]", (Object)genRes.profile().name(), (Object)genRes.id());
            }
        }
        return toReturn;
    }

    public static Map<AlgorithmCategory, AlgorithmCategoryDescriptor> getInstalledAlgorithms() throws AlgorithmManagementException {
        logger.debug("Loading dynamic algorithms, scope is " + ScopeUtils.getCurrentScope());
        AlgorithmConfiguration conf = AlgorithmManager.setUpBuildWPS(configPath);
        LinkedHashMap<AlgorithmCategory, AlgorithmCategoryDescriptor> toReturn = new LinkedHashMap<AlgorithmCategory, AlgorithmCategoryDescriptor>(staticallyLoadedAlgorithms);
        for (AlgorithmCategoryDescriptor categoryDescriptor : toReturn.values()) {
            for (Map.Entry<String, AlgorithmDescriptor> entry : categoryDescriptor.getAlgorithms().entrySet()) {
                if (!entry.getValue().isDinamycallyLoaded().booleanValue()) continue;
                try {
                    entry.getValue().update(AlgorithmManager.getAlgorithmDescriptor(categoryDescriptor.getCategory(), entry.getValue().getName(), conf));
                }
                catch (Exception e) {
                    String smExceptionMessage = "Unable to load " + entry.getValue().getName();
                    logger.warn(smExceptionMessage, (Throwable)e);
                    if (Boolean.parseBoolean(Configuration.getProperty("SKIP_FAULTY_ALGORITHMS"))) continue;
                    throw new AlgorithmManagementException(smExceptionMessage, e);
                }
            }
        }
        return toReturn;
    }

    public static Map<AlgorithmCategory, Set<AlgorithmDescriptor>> publishMissingAlgorithms() throws AlgorithmManagementException {
        logger.debug("Publishing missing algorithms in scope " + ScopeUtils.getCurrentScope());
        Map<AlgorithmCategory, Set<String>> inScope = AlgorithmManager.getInScope();
        LinkedHashMap<AlgorithmCategory, Set<AlgorithmDescriptor>> published = new LinkedHashMap<AlgorithmCategory, Set<AlgorithmDescriptor>>();
        for (Map.Entry<AlgorithmCategory, AlgorithmCategoryDescriptor> entry : AlgorithmManager.getInstalledAlgorithms().entrySet()) {
            logger.debug("Checking missing " + (Object)((Object)entry.getKey()));
            LinkedHashSet<AlgorithmDescriptor> toPublishSet = new LinkedHashSet<AlgorithmDescriptor>();
            Collection<AlgorithmDescriptor> algorithmsInCategory = entry.getValue().getAlgorithms().values();
            if (inScope.containsKey((Object)entry.getKey())) {
                for (AlgorithmDescriptor desc : algorithmsInCategory) {
                    if (inScope.get((Object)entry.getKey()).contains(desc.getName())) continue;
                    toPublishSet.add(desc);
                }
            } else {
                toPublishSet.addAll(algorithmsInCategory);
            }
            for (AlgorithmDescriptor toPublish : toPublishSet) {
                AlgorithmManager.publish(toPublish);
            }
            logger.debug("Published " + toPublishSet.size() + " " + (Object)((Object)entry.getKey()));
            published.put(entry.getKey(), toPublishSet);
        }
        return published;
    }

    private static GenericResource publish(AlgorithmDescriptor toPublish) {
        StringBuilder xmlBody = new StringBuilder();
        xmlBody.append("<category>");
        xmlBody.append(toPublish.getCategory().name());
        xmlBody.append("</category>");
        xmlBody.append("<inputs>");
        for (StatisticalType param : toPublish.getParameters().values()) {
            SMParameter smParameter = FactoryComputationParameter.createParameter(param);
            if (smParameter == null) continue;
            xmlBody.append("<input><name>" + smParameter.getName() + "</name>" + "<description>" + smParameter.getDescription() + "</description>" + "<defaultValue>" + smParameter.getDefaultValue() + "</defaultValue>" + "<type>" + smParameter.getType().getName() + "</type>" + "</input>");
        }
        xmlBody.append("</inputs>");
        GenericResource toCreate = new GenericResource();
        toCreate.newProfile().description(toPublish.getDescription()).name(toPublish.getName()).type(Configuration.getProperty("GR_SECONDARY_TYPE"));
        toCreate.profile().newBody(xmlBody.toString());
        logger.trace("Publishing algorithm " + toPublish + " in scope " + ScopeUtils.getCurrentScope());
        RegistryPublisher rp = RegistryPublisherFactory.create();
        return (GenericResource)rp.create((Resource)toCreate);
    }

    private static AlgorithmConfiguration setUpBuildWPS(String configPath) {
        AlgorithmConfiguration algoConfig = new AlgorithmConfiguration();
        algoConfig.setConfigPath(configPath);
        algoConfig.setPersistencePath(configPath);
        algoConfig.setGcubeScope(ScopeUtils.getCurrentScope());
        return algoConfig;
    }

    private static AlgorithmDescriptor getAlgorithmDescriptor(AlgorithmCategory category, String algorithmName, AlgorithmConfiguration config) throws AlgorithmManagementException {
        try {
            logger.debug("Loading algorithm " + (Object)((Object)category) + " " + algorithmName);
            List parameters = null;
            String description = null;
            StatisticalType output = null;
            switch (category) {
                case DISTRIBUTIONS: {
                    parameters = GeneratorsFactory.getAlgorithmParameters((String)config.getConfigPath(), (String)algorithmName);
                    description = GeneratorsFactory.getDescription((String)config.getConfigPath(), (String)algorithmName);
                    output = GeneratorsFactory.getAlgorithmOutput((String)config.getConfigPath(), (String)algorithmName);
                    break;
                }
                case EVALUATORS: {
                    parameters = EvaluatorsFactory.getEvaluatorParameters((String)config.getConfigPath(), (String)algorithmName);
                    description = EvaluatorsFactory.getDescription((String)config.getConfigPath(), (String)algorithmName);
                    output = EvaluatorsFactory.getEvaluatorOutput((String)config.getConfigPath(), (String)algorithmName);
                    break;
                }
                case MODELS: {
                    parameters = ModelersFactory.getModelParameters((String)config.getConfigPath(), (String)algorithmName);
                    description = ModelersFactory.getDescription((String)config.getConfigPath(), (String)algorithmName);
                    output = ModelersFactory.getModelOutput((String)config.getConfigPath(), (String)algorithmName);
                    break;
                }
                case TRANSDUCERS: {
                    description = TransducerersFactory.getDescription((AlgorithmConfiguration)config, (String)algorithmName);
                    try {
                        parameters = TransducerersFactory.getTransducerParameters((AlgorithmConfiguration)config, (String)algorithmName);
                        output = TransducerersFactory.getTransducerOutput((AlgorithmConfiguration)config, (String)algorithmName);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case CLUSTERERS: {
                    parameters = ClusterersFactory.getClustererParameters((String)config.getConfigPath(), (String)algorithmName);
                    description = ClusterersFactory.getDescription((String)config.getConfigPath(), (String)algorithmName);
                    output = ClusterersFactory.getClustererOutput((String)config.getConfigPath(), (String)algorithmName);
                }
            }
            if (parameters == null) {
                return new AlgorithmDescriptor(algorithmName, category);
            }
            return new AlgorithmDescriptor(algorithmName, category, parameters, description, output);
        }
        catch (Exception e) {
            throw new AlgorithmManagementException("Unable to load algorithm " + algorithmName + ", category is " + (Object)((Object)category), e);
        }
    }

    public static SMListGroupedAlgorithms asGroup(Map<AlgorithmCategory, AlgorithmCategoryDescriptor> toGroupAlgorithms) {
        ArrayList<SMGroupedAlgorithms> features = new ArrayList<SMGroupedAlgorithms>();
        for (Map.Entry<AlgorithmCategory, AlgorithmCategoryDescriptor> entry : toGroupAlgorithms.entrySet()) {
            SMGroupedAlgorithms feature = new SMGroupedAlgorithms();
            ArrayList<SMAlgorithm> smAlgorithms = AlgorithmDescriptor.asList(entry.getValue().getAlgorithms().values());
            feature.setCategory(entry.getKey().name());
            feature.setList(smAlgorithms.toArray(new SMAlgorithm[smAlgorithms.size()]));
            features.add(feature);
        }
        return new SMListGroupedAlgorithms(features.toArray(new SMGroupedAlgorithms[features.size()]));
    }

    public static SMListGroupedAlgorithms groupByUserPerspective(Map<AlgorithmCategory, AlgorithmCategoryDescriptor> toGroupAlgorithms) {
        LinkedHashMap grouped = new LinkedHashMap();
        for (Map.Entry<String, List<String>> entry : userPerspectiveMap.entrySet()) {
            ArrayList<AlgorithmDescriptor> categoryList = new ArrayList<AlgorithmDescriptor>();
            for (String toAdd : entry.getValue()) {
                try {
                    categoryList.add(AlgorithmManager.getAlgorithmByNameInMap(toGroupAlgorithms, toAdd));
                }
                catch (AlgorithmManagementException algorithmManagementException) {
                    // empty catch block
                }
            }
            if (categoryList.isEmpty()) continue;
            grouped.put(entry.getKey(), categoryList);
        }
        ArrayList<SMGroupedAlgorithms> features = new ArrayList<SMGroupedAlgorithms>();
        for (Map.Entry groupedEntry : grouped.entrySet()) {
            SMGroupedAlgorithms feature = new SMGroupedAlgorithms();
            ArrayList<SMAlgorithm> smAlgorithms = AlgorithmDescriptor.asList((Collection)groupedEntry.getValue());
            feature.setCategory((String)groupedEntry.getKey());
            feature.setList(smAlgorithms.toArray(new SMAlgorithm[smAlgorithms.size()]));
            features.add(feature);
        }
        return new SMListGroupedAlgorithms(features.toArray(new SMGroupedAlgorithms[features.size()]));
    }

    public static Map<AlgorithmCategory, AlgorithmCategoryDescriptor> getAvailableAlgorithms(SMTypeParameter[] toFilterBy) throws AlgorithmManagementException {
        logger.debug("Getting available algorithms under scope " + ScopeUtils.getCurrentScope() + " filter by " + toFilterBy);
        Map<AlgorithmCategory, Set<String>> inScope = AlgorithmManager.getInScope();
        LinkedHashMap<AlgorithmCategory, AlgorithmCategoryDescriptor> toReturn = new LinkedHashMap<AlgorithmCategory, AlgorithmCategoryDescriptor>();
        for (Map.Entry<AlgorithmCategory, AlgorithmCategoryDescriptor> entry : AlgorithmManager.getInstalledAlgorithms().entrySet()) {
            if (inScope.containsKey((Object)entry.getKey())) {
                Set<String> inScopeAlgos = inScope.get((Object)entry.getKey());
                LinkedHashSet<AlgorithmDescriptor> toSet = new LinkedHashSet<AlgorithmDescriptor>();
                block3: for (AlgorithmDescriptor installed : entry.getValue().getAlgorithms().values()) {
                    if (!inScopeAlgos.contains(installed.getName())) continue;
                    try {
                        if (toFilterBy == null || toFilterBy.length == 0) {
                            toSet.add(new AlgorithmDescriptor(installed));
                            continue;
                        }
                        Collection<StatisticalType> algorithmParameters = installed.getParameters().values();
                        SMTypeParameter[] sMTypeParameterArray = toFilterBy;
                        int n = toFilterBy.length;
                        int n2 = 0;
                        while (n2 < n) {
                            SMTypeParameter param = sMTypeParameterArray[n2];
                            if (AlgorithmManager.containParameter(param, algorithmParameters)) {
                                toSet.add(new AlgorithmDescriptor(installed));
                                continue block3;
                            }
                            ++n2;
                        }
                    }
                    catch (Throwable t) {
                        logger.warn("Invalid Algorithm " + installed, t);
                    }
                }
                logger.debug("filtered " + toSet.size() + "/" + entry.getValue().getAlgorithms().size() + " " + (Object)((Object)entry.getKey()) + " algorithm(s).");
                toReturn.put(entry.getKey(), new AlgorithmCategoryDescriptor(entry.getKey(), toSet));
                continue;
            }
            logger.debug("No " + (Object)((Object)entry.getKey()) + " found in current scope " + ScopeUtils.getCurrentScope());
        }
        return toReturn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean containParameter(SMTypeParameter typeParameter, Collection<StatisticalType> statisticalParameters) {
        try {
            if (typeParameter != null && typeParameter.getName().equals((Object)StatisticalServiceType.TABULAR)) {
                for (StatisticalType type : statisticalParameters) {
                    if (!(type instanceof InputTable)) continue;
                    String[] stringArray = typeParameter.getValues();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String template = stringArray[n2];
                        if (((InputTable)type).getTemplateNames().contains(TableTemplates.GENERIC) || ((InputTable)type).getTemplateNames().contains(TableTemplates.valueOf((String)template))) {
                            return true;
                        }
                        ++n2;
                    }
                }
            }
            return false;
        }
        catch (Exception e) {
            logger.debug("Type Parameter is invalid not considering it among filters, " + (typeParameter != null ? "Name : " + typeParameter.getName() + " values " + typeParameter.getValues() : " parameter null"));
            return true;
        }
    }
}

