/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.persistence;

import java.security.Key;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.common.Platform;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.Configuration;
import org.gcube.data.analysis.statisticalmanager.exception.ISException;
import org.gcube.data.analysis.statisticalmanager.persistence.AccessPointDescriptor;
import org.gcube.data.analysis.statisticalmanager.persistence.DatabaseType;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeResourceManager {
    private static Logger logger = LoggerFactory.getLogger(RuntimeResourceManager.class);

    public static AccessPointDescriptor getDatabaseProfile(DatabaseType type) throws ISException {
        logger.debug("Get Access point for " + (Object)((Object)type) + " under scope" + ScopeProvider.instance.get());
        String rrName = Configuration.getProperty("RUNTIME_RESOURCE_DB");
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name/text() eq '" + rrName + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        if (resources == null || resources.isEmpty()) {
            throw new ISException("Runtime resource " + rrName + " not found");
        }
        ServiceEndpoint resource = (ServiceEndpoint)resources.get(0);
        logger.debug("Checking service point ID " + resource.id());
        if (resource.profile().accessPoints() == null || resource.profile().accessPoints().isEmpty()) {
            throw new ISException("No AccessPoint defined in " + rrName + " not found");
        }
        for (ServiceEndpoint.AccessPoint ap : resource.profile().accessPoints()) {
            if (!ap.name().equals(type.getAccessPointName())) continue;
            try {
                return new AccessPointDescriptor(ap.address(), ap.username(), StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]));
            }
            catch (Exception e) {
                throw new ISException("Unable to decrypt information", e);
            }
        }
        throw new ISException("AccessPoint not found for " + (Object)((Object)type));
    }

    public static HashMap<String, String> getServiceEndpointAsMap(String runtimeResource) throws ISException {
        logger.debug("Get ServiceEndpoint " + runtimeResource + " Under scope " + ScopeProvider.instance.get());
        HashMap<String, String> toReturn = new HashMap<String, String>();
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name/text() eq '" + runtimeResource + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        try {
            Iterator iterator;
            ServiceEndpoint resource = (ServiceEndpoint)client.submit((Query)query).get(0);
            logger.debug("Found resource ID " + resource.id());
            String sc = "";
            for (String scope : resource.scopes()) {
                sc = String.valueOf(sc) + scope + ";";
            }
            toReturn.put(String.valueOf(runtimeResource) + "." + "Scopes", sc);
            ServiceEndpoint.Profile profile = resource.profile();
            toReturn.put(String.valueOf(runtimeResource) + "." + "Profile.Category", profile.category());
            Platform platform = profile.platform();
            toReturn.put(String.valueOf(runtimeResource) + "." + "Profile.Platform.name", platform.name());
            toReturn.put(String.valueOf(runtimeResource) + "." + "Profile.Platform.version", Integer.toString(platform.version()));
            toReturn.put(String.valueOf(runtimeResource) + "." + "Profile.Platform.minorVersion", Integer.toString(platform.minorVersion().shortValue()));
            toReturn.put(String.valueOf(runtimeResource) + "." + "Profile.Platform.revisionVersion", Integer.toString(platform.revisionVersion().shortValue()));
            toReturn.put(String.valueOf(runtimeResource) + "." + "Profile.Platform.buildVersion", Integer.toString(platform.buildVersion().shortValue()));
            ServiceEndpoint.Runtime runtime = profile.runtime();
            toReturn.put(String.valueOf(runtimeResource) + "." + "Profile.Runtime.hostedOn", runtime.hostedOn());
            toReturn.put(String.valueOf(runtimeResource) + "." + "Profile.Runtime.status", runtime.status());
            toReturn.put(String.valueOf(runtimeResource) + "." + "Profile.Runtime.ghnId", runtime.ghnId());
            if (profile.accessPoints() != null && (iterator = profile.accessPoints().iterator()).hasNext()) {
                ServiceEndpoint.AccessPoint accessPoint = (ServiceEndpoint.AccessPoint)iterator.next();
                toReturn.put(String.valueOf(runtimeResource) + "." + "AccessPoint.Description", accessPoint.description());
                toReturn.put(String.valueOf(runtimeResource) + "." + "AccessPoint.Address", accessPoint.address());
                toReturn.put(String.valueOf(runtimeResource) + "." + "AccessPoint.Password", StringEncrypter.getEncrypter().decrypt(accessPoint.password(), new Key[0]));
                toReturn.put(String.valueOf(runtimeResource) + "." + "AccessPoint.Username", accessPoint.username());
                for (Map.Entry entry : accessPoint.propertyMap().entrySet()) {
                    String propertyName = String.valueOf(runtimeResource) + "." + ((String)entry.getKey()).toString();
                    String propertyVal = ((ServiceEndpoint.Property)entry.getValue()).toString();
                    toReturn.put(propertyName, propertyVal);
                }
            }
            return toReturn;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ISException("Runtime resource " + runtimeResource + " not found");
        }
        catch (Exception e) {
            throw new ISException("Unable to decrypt information", e);
        }
    }

    public static Group<ServiceEndpoint.AccessPoint> getRRAccessPoint(String runtimeResource) throws ISException {
        try {
            logger.debug("Get Access Points for ServiceEndpoint " + runtimeResource + " under scope " + ScopeProvider.instance.get());
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Name/text() eq '" + runtimeResource + "'");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            ServiceEndpoint resource = (ServiceEndpoint)client.submit((Query)query).get(0);
            if (resource.profile().accessPoints() == null || resource.profile().accessPoints().isEmpty()) {
                throw new ISException("Accesspoint in resource " + runtimeResource + " not found");
            }
            return resource.profile().accessPoints();
        }
        catch (IndexOutOfBoundsException e) {
            throw new ISException("Runtime resource " + runtimeResource + " not found");
        }
    }
}

