/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.sf.csv4j.CSVFileProcessor;
import net.sf.csv4j.CSVLineProcessor;
import org.gcube.data.analysis.statisticalmanager.dataspace.importer.CSVLineProcessorGeneric;
import org.gcube.data.analysis.statisticalmanager.dataspace.importer.CSVLineProcessorOcc;
import org.gcube.data.analysis.statisticalmanager.dataspace.importer.CSVLineProcessorTimeSeries;
import org.gcube.data.analysis.statisticalmanager.persistence.DataBaseManager;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVImporter {
    private static Logger logger = LoggerFactory.getLogger(CSVImporter.class);
    private File file;
    private boolean hasHeader;
    private String tableTemplate;
    private String delimiter;
    private char comment;

    public CSVImporter(File file, boolean hasHeader, String tableLabel, String tableTemplate, String delimiter, String comment) {
        this.file = file;
        this.hasHeader = hasHeader;
        this.tableTemplate = tableTemplate;
        this.delimiter = delimiter;
        this.comment = comment != null && !comment.isEmpty() ? comment.charAt(0) : (char)35;
        logger.debug(String.format("Import %s [hasHeader %s, label %s, template %s, delimiter %s, comment %s]", file.getAbsoluteFile(), hasHeader, tableLabel, tableTemplate, this.delimiter, Character.valueOf(this.comment)));
    }

    public String toTabularData() throws Exception {
        Connection conn = null;
        PreparedStatement createTable = null;
        String dbTableName = null;
        DataBaseManager db = DataBaseManager.get();
        try {
            try {
                conn = DriverManager.getConnection(db.getUrlDB(), db.getUsername(), db.getPassword());
                conn.setAutoCommit(false);
                dbTableName = String.valueOf(this.tableTemplate) + "_ID" + UUID.randomUUID().toString().replace("-", "_");
                dbTableName = dbTableName.toLowerCase();
                String sql = null;
                sql = this.tableTemplate.equals(TableTemplates.GENERIC.toString()) ? this.getSqlStatmentCreateGeneric(dbTableName) : (this.tableTemplate.equals(TableTemplates.TIMESERIES.toString()) ? this.getSqlStatmentCreateTimeSeriesSecondEdition(dbTableName) : (this.tableTemplate.equals(TableTemplates.OCCURRENCE_SPECIES.toString()) ? this.getSqlStatmentCreateOther(dbTableName) : String.format("create table %s (like %s)", dbTableName, this.tableTemplate)));
                logger.debug("SQL create table: " + sql);
                createTable = conn.prepareStatement(sql);
                createTable.executeUpdate();
                String sqlCopy = String.format("COPY %s FROM STDIN WITH DELIMITER '%s' %s QUOTE '\"' ESCAPE '\\' ", dbTableName, this.delimiter, this.hasHeader ? "CSV HEADER" : "CSV");
                logger.debug("SQL IS : " + sqlCopy);
                CopyManager copyManager = new CopyManager((BaseConnection)conn);
                copyManager.copyIn(sqlCopy, (InputStream)new FileInputStream(this.file));
                conn.commit();
            }
            catch (Exception e) {
                logger.error("CSV importer error :", (Throwable)e);
                e.printStackTrace();
                db.rollback(conn);
                throw new Exception(e);
            }
        }
        catch (Throwable throwable) {
            db.closeStatement(createTable);
            db.closeConn(conn);
            throw throwable;
        }
        db.closeStatement(createTable);
        db.closeConn(conn);
        return dbTableName;
    }

    private String getSqlStatmentCreateGeneric(String dbTableName) throws Exception {
        CSVFileProcessor fp = new CSVFileProcessor();
        CSVLineProcessorGeneric lineProcessor = new CSVLineProcessorGeneric(this.delimiter);
        fp.setHasHeader(this.hasHeader);
        fp.setComment(this.comment);
        try {
            try {
                fp.processFile(this.file.getAbsolutePath(), (CSVLineProcessor)lineProcessor);
            }
            catch (NullPointerException e) {
                logger.warn("file " + (this.file != null ? this.file.getAbsolutePath() : "NULL FILE") + "finished before counted");
            }
        }
        catch (Throwable throwable) {}
        logger.debug("hasHeader " + this.hasHeader);
        logger.debug("comment" + this.comment);
        ArrayList<String> sqltypes = new ArrayList<String>();
        logger.debug("Size column" + lineProcessor.firstColumns.size());
        for (ArrayList<String> column : lineProcessor.firstColumns) {
            logger.debug("Print conlumn");
            sqltypes.add(CSVLineProcessorGeneric.getSqlType(column));
            logger.debug("add type ");
        }
        lineProcessor.addSqlType(sqltypes);
        List<String> cols = lineProcessor.getColsName();
        logger.debug("cols.size:" + cols.size());
        logger.debug("addSqlType.size:" + lineProcessor.getSqlType().size());
        logger.debug("Types:");
        String args = "";
        int i = 0;
        for (String colName : cols) {
            args = i >= lineProcessor.getSqlType().size() ? String.valueOf(args) + String.format("%s %s,", colName, "varchar") : String.valueOf(args) + String.format("%s %s,", colName, lineProcessor.getSqlType().get(i++));
            logger.debug("args" + args);
        }
        String sql = String.format("CREATE TABLE %s ( %s )", dbTableName, args.substring(0, args.length() - 1));
        return sql;
    }

    private String getSqlStatmentCreateOther(String dbTableName) throws Exception {
        CSVFileProcessor fp = new CSVFileProcessor();
        CSVLineProcessorOcc lineProcessor = new CSVLineProcessorOcc(this.delimiter);
        fp.setHasHeader(this.hasHeader);
        fp.setComment(this.comment);
        try {
            try {
                fp.processFile(this.file.getAbsolutePath(), (CSVLineProcessor)lineProcessor);
            }
            catch (NullPointerException e) {
                logger.warn("file " + (this.file != null ? this.file.getAbsolutePath() : "NULL FILE") + "finished before counted");
            }
        }
        catch (Throwable throwable) {}
        logger.debug("hasHeader " + this.hasHeader);
        logger.debug("comment" + this.comment);
        ArrayList<String> sqltypes = new ArrayList<String>();
        logger.debug("Size column" + lineProcessor.firstColumns.size());
        for (ArrayList<String> column : lineProcessor.firstColumns) {
            logger.debug("Print conlumn");
            sqltypes.add(CSVLineProcessorGeneric.getSqlType(column));
            logger.debug("add type ");
        }
        lineProcessor.addSqlType(sqltypes);
        List<String> cols = lineProcessor.getColsName();
        logger.debug("cols.size:" + cols.size());
        logger.debug("addSqlType.size:" + lineProcessor.getSqlType().size());
        logger.debug("Types:");
        String args = "";
        int i = 0;
        for (String colName : cols) {
            args = i >= lineProcessor.getSqlType().size() ? String.valueOf(args) + String.format("%s %s,", colName, "varchar") : String.valueOf(args) + String.format("%s %s,", colName, lineProcessor.getSqlType().get(i++));
            logger.debug("args" + args);
        }
        lineProcessor.getWellFormaFile(this.file);
        this.file = lineProcessor.getFile();
        logger.debug("***reassingned File path is " + this.file.getAbsolutePath());
        String sql = "CREATE TABLE " + dbTableName + "(institutionCode VARCHAR," + "collectionCode VARCHAR," + "catalogueNumber VARCHAR," + "dataSet VARCHAR," + "dataProvider VARCHAR," + "dataSource VARCHAR," + "scientificNameAuthorship VARCHAR," + "identifiedBy VARCHAR," + "credits VARCHAR," + "recordedBy VARCHAR," + "eventDate TIMESTAMP," + "modified TIMESTAMP," + "scientificName VARCHAR," + "kingdom VARCHAR," + "family VARCHAR," + "locality VARCHAR," + "country VARCHAR," + "citation VARCHAR," + "decimalLatitude double precision," + "decimalLongitude double precision," + "coordinateUncertaintyInMeters VARCHAR," + "maxDepth double precision," + "minDepth double precision," + "basisOfRecord VARCHAR)";
        return sql;
    }

    private String getSqlStatmentCreateTimeSeriesSecondEdition(String dbTableName) throws Exception {
        CSVFileProcessor fp = new CSVFileProcessor();
        CSVLineProcessorTimeSeries lineProcessor = new CSVLineProcessorTimeSeries(this.delimiter);
        fp.setHasHeader(this.hasHeader);
        fp.setComment(this.comment);
        try {
            try {
                fp.processFile(this.file.getAbsolutePath(), (CSVLineProcessor)lineProcessor);
            }
            catch (NullPointerException e) {
                logger.debug("file finished before counted");
            }
        }
        catch (Throwable throwable) {}
        logger.debug("hasHeader " + this.hasHeader);
        logger.debug("comment" + this.comment);
        ArrayList<String> sqltypes = new ArrayList<String>();
        logger.debug("Size column" + lineProcessor.firstColumns.size());
        for (ArrayList<String> column : lineProcessor.firstColumns) {
            logger.debug("Print conlumn");
            sqltypes.add(CSVLineProcessorTimeSeries.getSqlType(column));
            logger.debug("added type ");
        }
        lineProcessor.addSqlType(sqltypes);
        List<String> cols = lineProcessor.getColsName();
        logger.debug("cols.size:" + cols.size());
        logger.debug("addSqlType.size:" + lineProcessor.getSqlType().size());
        logger.debug("Types:");
        logger.debug("hasHeader " + this.hasHeader);
        logger.debug("comment" + this.comment);
        String args = "";
        int i = 0;
        int indexTime = 0;
        boolean thereIstTimeColumn = false;
        for (String colName : cols) {
            logger.debug("***COL name ***" + cols);
            if (i >= lineProcessor.getSqlType().size()) {
                args = String.valueOf(args) + String.format("%s %s,", colName, "varchar");
            } else if (colName.equals("time")) {
                logger.debug("***IS TIME ***");
                args = String.valueOf(args) + String.format("%s %s,", colName, "timestamp without time zone");
                thereIstTimeColumn = true;
                indexTime = i++;
            } else {
                args = String.valueOf(args) + String.format("%s %s,", colName, lineProcessor.getSqlType().get(i++));
            }
            logger.debug("args" + args);
        }
        if (!thereIstTimeColumn) {
            throw new Exception("There isn't the \"Time\" column in Timeseries dataset.");
        }
        lineProcessor.getWellFormaFile(this.file, indexTime);
        this.file = lineProcessor.getFile();
        logger.debug("***reassingned File path is " + this.file.getAbsolutePath());
        String sql = String.format("CREATE TABLE %s ( %s )", dbTableName, args.substring(0, args.length() - 1));
        return sql;
    }
}

