/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.persistence;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeNotSupportedException;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.access.queueManager.FactoryConfiguration;
import org.gcube.data.access.queueManager.QueueItemHandler;
import org.gcube.data.access.queueManager.QueueType;
import org.gcube.data.access.queueManager.impl.QueueConsumer;
import org.gcube.data.access.queueManager.impl.QueueConsumerFactory;
import org.gcube.data.access.queueManager.impl.QueueProducer;
import org.gcube.data.access.queueManager.impl.QueueProducerFactory;
import org.gcube.data.access.queueManager.model.QueueItem;
import org.gcube.data.access.queueManager.model.RequestItem;
import org.gcube.data.analysis.statisticalmanager.Configuration;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ServiceQueueConsumer;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceQueueManager {
    private static Logger logger = LoggerFactory.getLogger(ServiceQueueManager.class);
    private static ConcurrentHashMap<String, ServiceQueueManager> producerMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> endpointMap = new ConcurrentHashMap();
    private QueueProducer<QueueItem> producer;
    private QueueConsumer<QueueItem> consumer;
    private String operatingScope;
    private String topicName;
    private FactoryConfiguration queueConfig;
    private String endpoint;

    public static synchronized ServiceQueueManager getProducer() throws GCUBEScope.MalformedScopeExpressionException, GCUBEScopeNotSupportedException, JMSException, StatisticalManagerException {
        String toConsiderScope = ScopeProvider.instance.get();
        logger.debug("Scope is " + toConsiderScope);
        if (toConsiderScope.split("/").length > 3) {
            toConsiderScope = toConsiderScope.substring(0, toConsiderScope.lastIndexOf("/"));
            logger.debug("Reducing scope to VO : " + toConsiderScope);
        }
        if (!producerMap.containsKey(toConsiderScope)) {
            producerMap.put(toConsiderScope, new ServiceQueueManager(toConsiderScope));
        }
        return producerMap.get(toConsiderScope);
    }

    public static synchronized void sendItem(RequestItem item) throws JMSException, GCUBEScope.MalformedScopeExpressionException, GCUBEScopeNotSupportedException, StatisticalManagerException {
        logger.debug("Sending item " + item);
        ServiceQueueManager queueManager = ServiceQueueManager.getProducer();
        logger.debug("got producer " + queueManager);
        logger.debug("Sent item ID : " + queueManager.producer.send((QueueItem)item));
    }

    private static String endPointByScope() throws GCUBEScope.MalformedScopeExpressionException, GCUBEScopeNotSupportedException, StatisticalManagerException {
        String currentScope = ScopeProvider.instance.get();
        if (!endpointMap.containsKey(currentScope)) {
            logger.debug("Getting JMS endpoint for new scope " + currentScope);
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Category/text() eq '" + Configuration.getProperty(Configuration.JMS_SERVICE_ENDPOINT_CATEGORY) + "' and $resource/Profile/Name eq '" + Configuration.getProperty(Configuration.JMS_SERVICE_ENDPOINT_NAME) + "' ");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            List resources = client.submit((Query)query);
            if (resources == null || resources.size() == 0) {
                throw new StatisticalManagerException("No resources found in scope " + currentScope);
            }
            ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)((ServiceEndpoint)resources.get(0)).profile().accessPoints().iterator().next();
            endpointMap.put(currentScope, ap.address());
        }
        return endpointMap.get(currentScope);
    }

    private ServiceQueueManager(String toConsiderScope) throws JMSException, GCUBEScope.MalformedScopeExpressionException, GCUBEScopeNotSupportedException, StatisticalManagerException {
        this.operatingScope = toConsiderScope;
        this.topicName = String.valueOf(Configuration.getProperty(Configuration.JMS_TOPIC)) + "_" + this.operatingScope.replaceAll("/", "_");
        this.endpoint = ServiceQueueManager.endPointByScope();
        logger.debug("Instantiating queue manager under scope " + this.operatingScope + ", found endpoint" + this.endpoint + ".Topic name : " + this.topicName);
        this.queueConfig = new FactoryConfiguration(Configuration.getProperty(Configuration.JMS_SERVICE_CLASS), Configuration.getProperty(Configuration.JMS_SERVICE_NAME), this.endpoint, null, null);
        this.queueConfig.setInitialRedeliveryDelay(5000L);
        this.queueConfig.setMaximumRedeliveries(-1);
        this.queueConfig.setUseExponentialRedelivery(false);
        logger.debug("Configuration is " + this.queueConfig);
        QueueConsumerFactory consumerFactory = QueueConsumerFactory.get((FactoryConfiguration)this.queueConfig);
        ServiceQueueConsumer handler = new ServiceQueueConsumer(this.topicName, consumerFactory);
        this.consumer = consumerFactory.register(this.topicName, QueueType.REQUEST, (QueueItemHandler)handler);
        logger.debug("Consumer registered");
        this.initProducer();
    }

    public QueueConsumer<QueueItem> consumer() {
        return this.consumer;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public QueueProducer<QueueItem> producer() throws JMSException {
        if (!this.producer.isActive()) {
            try {
                this.producer.close();
            }
            catch (Exception e) {
                logger.warn("Unabel to close JMS producer ", (Throwable)e);
            }
            this.initProducer();
        }
        return this.producer;
    }

    private void initProducer() throws JMSException {
        QueueProducerFactory factory = QueueProducerFactory.get((FactoryConfiguration)this.queueConfig);
        this.producer = factory.getSubmitter(this.topicName, QueueType.REQUEST);
    }

    public String toString() {
        return "QueueManager for Scope " + this.operatingScope + ". Configuration is :" + this.queueConfig.toString();
    }
}

