/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.sf.csv4j.CSVFileProcessor;
import net.sf.csv4j.CSVLineProcessor;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.dataspace.importer.CSVLineProcessorGeneric;
import org.gcube.data.analysis.statisticalmanager.dataspace.importer.CSVLineProcessorOcc;
import org.gcube.data.analysis.statisticalmanager.dataspace.importer.CSVLineProcessorTimeSeries;
import org.gcube.data.analysis.statisticalmanager.persistence.DataBaseManager;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;

public class CSVImporter {
    private static GCUBELog logger = new GCUBELog(CSVImporter.class);
    private File file;
    private boolean hasHeader;
    private String tableLabel;
    private String tableTemplate;
    private String delimiter;
    private char comment;

    public CSVImporter(File file, boolean hasHeader, String tableLabel, String tableTemplate, String delimiter, String comment) {
        this.file = file;
        this.hasHeader = hasHeader;
        this.tableLabel = tableLabel;
        this.tableTemplate = tableTemplate;
        this.delimiter = delimiter;
        this.comment = comment != null && !comment.isEmpty() ? comment.charAt(0) : (char)35;
    }

    public String toTabularData() throws Exception {
        Connection conn = null;
        PreparedStatement createTable = null;
        String dbTableName = null;
        try {
            conn = DriverManager.getConnection(DataBaseManager.getUrlDB(), DataBaseManager.getUsername(), DataBaseManager.getPassword());
            conn.setAutoCommit(false);
            dbTableName = this.tableTemplate + "_ID" + UUID.randomUUID().toString().replace("-", "_");
            dbTableName = dbTableName.toLowerCase();
            String sql = null;
            sql = this.tableTemplate.equals(TableTemplates.GENERIC.toString()) ? this.getSqlStatmentCreateGeneric(dbTableName) : (this.tableTemplate.equals(TableTemplates.TIMESERIES.toString()) ? this.getSqlStatmentCreateTimeSeriesSecondEdition(dbTableName) : (this.tableTemplate.equals(TableTemplates.OCCURRENCE_SPECIES.toString()) ? this.getSqlStatmentCreateOther(dbTableName) : String.format("create table %s (like %s)", dbTableName, this.tableTemplate)));
            logger.debug((Object)("SQL create table: " + sql));
            System.out.println("SQL create table: " + sql);
            createTable = conn.prepareStatement(sql);
            createTable.executeUpdate();
            System.out.println("SQL string " + String.format("COPY %s FROM STDIN WITH DELIMITER '%s' %s  QUOTE '\"' ESCAPE '\\\\' ", dbTableName, this.delimiter, this.hasHeader ? "CSV HEADER" : "CSV"));
            System.out.println("**File path is " + this.file.getAbsolutePath());
            CopyManager copyManager = new CopyManager((BaseConnection)conn);
            copyManager.copyIn(String.format("COPY %s FROM STDIN WITH DELIMITER '%s' %s QUOTE '\"' ESCAPE '\\\\' ", dbTableName, this.delimiter, this.hasHeader ? "CSV HEADER" : "CSV"), (InputStream)new FileInputStream(this.file));
            conn.commit();
        }
        catch (Exception e) {
            try {
                logger.error((Object)"CSV importer error :", (Throwable)e);
                e.printStackTrace();
                DataBaseManager.rollback(conn);
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                DataBaseManager.closeStatement(createTable);
                DataBaseManager.closeConn(conn);
                throw throwable;
            }
        }
        DataBaseManager.closeStatement(createTable);
        DataBaseManager.closeConn(conn);
        return dbTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSqlStatmentCreateGeneric(String dbTableName) throws Exception {
        CSVFileProcessor fp = new CSVFileProcessor();
        CSVLineProcessorGeneric lineProcessor = new CSVLineProcessorGeneric(this.delimiter);
        fp.setHasHeader(this.hasHeader);
        fp.setComment(this.comment);
        try {
            fp.processFile(this.file.getAbsolutePath(), (CSVLineProcessor)lineProcessor);
        }
        catch (NullPointerException e) {
            try {
                e.printStackTrace();
                logger.debug((Object)"file finished before counted");
            }
            catch (Throwable throwable) {
                logger.debug((Object)("hasHeader " + this.hasHeader));
                logger.debug((Object)("comment" + this.comment));
                ArrayList<String> sqltypes = new ArrayList<String>();
                logger.debug((Object)("Size column" + lineProcessor.firstColumns.size()));
                for (ArrayList<String> column : lineProcessor.firstColumns) {
                    logger.debug((Object)"Print conlumn");
                    sqltypes.add(CSVLineProcessorGeneric.getSqlType(column));
                    logger.debug((Object)"add type ");
                }
                lineProcessor.addSqlType(sqltypes);
                List<String> cols = lineProcessor.getColsName();
                logger.debug((Object)("cols.size:" + cols.size()));
                logger.debug((Object)("addSqlType.size:" + lineProcessor.getSqlType().size()));
                logger.debug((Object)"Types:");
                String args = "";
                int i = 0;
                for (String colName : cols) {
                    args = i >= lineProcessor.getSqlType().size() ? args + String.format("%s %s,", colName, "varchar") : args + String.format("%s %s,", colName, lineProcessor.getSqlType().get(i++));
                    logger.debug((Object)("args" + args));
                }
                String sql = String.format("CREATE TABLE %s ( %s )", dbTableName, args.substring(0, args.length() - 1));
                return sql;
            }
            logger.debug((Object)("hasHeader " + this.hasHeader));
            logger.debug((Object)("comment" + this.comment));
            ArrayList<String> sqltypes = new ArrayList<String>();
            logger.debug((Object)("Size column" + lineProcessor.firstColumns.size()));
            for (ArrayList<String> column : lineProcessor.firstColumns) {
                logger.debug((Object)"Print conlumn");
                sqltypes.add(CSVLineProcessorGeneric.getSqlType(column));
                logger.debug((Object)"add type ");
            }
            lineProcessor.addSqlType(sqltypes);
            List<String> cols = lineProcessor.getColsName();
            logger.debug((Object)("cols.size:" + cols.size()));
            logger.debug((Object)("addSqlType.size:" + lineProcessor.getSqlType().size()));
            logger.debug((Object)"Types:");
            String args = "";
            int i = 0;
            for (String colName : cols) {
                args = i >= lineProcessor.getSqlType().size() ? args + String.format("%s %s,", colName, "varchar") : args + String.format("%s %s,", colName, lineProcessor.getSqlType().get(i++));
                logger.debug((Object)("args" + args));
            }
            String sql = String.format("CREATE TABLE %s ( %s )", dbTableName, args.substring(0, args.length() - 1));
            return sql;
        }
        logger.debug((Object)("hasHeader " + this.hasHeader));
        logger.debug((Object)("comment" + this.comment));
        ArrayList<String> sqltypes = new ArrayList<String>();
        logger.debug((Object)("Size column" + lineProcessor.firstColumns.size()));
        for (ArrayList<String> column : lineProcessor.firstColumns) {
            logger.debug((Object)"Print conlumn");
            sqltypes.add(CSVLineProcessorGeneric.getSqlType(column));
            logger.debug((Object)"add type ");
        }
        lineProcessor.addSqlType(sqltypes);
        List<String> cols = lineProcessor.getColsName();
        logger.debug((Object)("cols.size:" + cols.size()));
        logger.debug((Object)("addSqlType.size:" + lineProcessor.getSqlType().size()));
        logger.debug((Object)"Types:");
        String args = "";
        int i = 0;
        for (String colName : cols) {
            args = i >= lineProcessor.getSqlType().size() ? args + String.format("%s %s,", colName, "varchar") : args + String.format("%s %s,", colName, lineProcessor.getSqlType().get(i++));
            logger.debug((Object)("args" + args));
        }
        String sql = String.format("CREATE TABLE %s ( %s )", dbTableName, args.substring(0, args.length() - 1));
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSqlStatmentCreateOther(String dbTableName) throws Exception {
        CSVFileProcessor fp = new CSVFileProcessor();
        CSVLineProcessorOcc lineProcessor = new CSVLineProcessorOcc(this.delimiter);
        fp.setHasHeader(this.hasHeader);
        fp.setComment(this.comment);
        try {
            fp.processFile(this.file.getAbsolutePath(), (CSVLineProcessor)lineProcessor);
        }
        catch (NullPointerException e) {
            try {
                e.printStackTrace();
                logger.debug((Object)"file finished before counted");
            }
            catch (Throwable throwable) {
                logger.debug((Object)("hasHeader " + this.hasHeader));
                logger.debug((Object)("comment" + this.comment));
                ArrayList<String> sqltypes = new ArrayList<String>();
                logger.debug((Object)("Size column" + lineProcessor.firstColumns.size()));
                for (ArrayList<String> column : lineProcessor.firstColumns) {
                    logger.debug((Object)"Print conlumn");
                    sqltypes.add(CSVLineProcessorGeneric.getSqlType(column));
                    logger.debug((Object)"add type ");
                }
                lineProcessor.addSqlType(sqltypes);
                List<String> cols = lineProcessor.getColsName();
                logger.debug((Object)("cols.size:" + cols.size()));
                logger.debug((Object)("addSqlType.size:" + lineProcessor.getSqlType().size()));
                logger.debug((Object)"Types:");
                String args = "";
                int i = 0;
                for (String colName : cols) {
                    args = i >= lineProcessor.getSqlType().size() ? args + String.format("%s %s,", colName, "varchar") : args + String.format("%s %s,", colName, lineProcessor.getSqlType().get(i++));
                    logger.debug((Object)("args" + args));
                }
                lineProcessor.getWellFormaFile(this.file);
                this.file = lineProcessor.getFile();
                logger.debug((Object)("***reassingned File path is " + this.file.getAbsolutePath()));
                String sql = "CREATE TABLE " + dbTableName + "(institutionCode VARCHAR," + "collectionCode VARCHAR," + "catalogueNumber VARCHAR," + "dataSet VARCHAR," + "dataProvider VARCHAR," + "dataSource VARCHAR," + "scientificNameAuthorship VARCHAR," + "identifiedBy VARCHAR," + "credits VARCHAR," + "recordedBy VARCHAR," + "eventDate TIMESTAMP," + "modified TIMESTAMP," + "scientificName VARCHAR," + "kingdom VARCHAR," + "family VARCHAR," + "locality VARCHAR," + "country VARCHAR," + "citation VARCHAR," + "decimalLatitude double precision," + "decimalLongitude double precision," + "coordinateUncertaintyInMeters VARCHAR," + "maxDepth double precision," + "minDepth double precision," + "basisOfRecord VARCHAR)";
                return sql;
            }
            logger.debug((Object)("hasHeader " + this.hasHeader));
            logger.debug((Object)("comment" + this.comment));
            ArrayList<String> sqltypes = new ArrayList<String>();
            logger.debug((Object)("Size column" + lineProcessor.firstColumns.size()));
            for (ArrayList<String> column : lineProcessor.firstColumns) {
                logger.debug((Object)"Print conlumn");
                sqltypes.add(CSVLineProcessorGeneric.getSqlType(column));
                logger.debug((Object)"add type ");
            }
            lineProcessor.addSqlType(sqltypes);
            List<String> cols = lineProcessor.getColsName();
            logger.debug((Object)("cols.size:" + cols.size()));
            logger.debug((Object)("addSqlType.size:" + lineProcessor.getSqlType().size()));
            logger.debug((Object)"Types:");
            String args = "";
            int i = 0;
            for (String colName : cols) {
                args = i >= lineProcessor.getSqlType().size() ? args + String.format("%s %s,", colName, "varchar") : args + String.format("%s %s,", colName, lineProcessor.getSqlType().get(i++));
                logger.debug((Object)("args" + args));
            }
            lineProcessor.getWellFormaFile(this.file);
            this.file = lineProcessor.getFile();
            logger.debug((Object)("***reassingned File path is " + this.file.getAbsolutePath()));
            String sql = "CREATE TABLE " + dbTableName + "(institutionCode VARCHAR," + "collectionCode VARCHAR," + "catalogueNumber VARCHAR," + "dataSet VARCHAR," + "dataProvider VARCHAR," + "dataSource VARCHAR," + "scientificNameAuthorship VARCHAR," + "identifiedBy VARCHAR," + "credits VARCHAR," + "recordedBy VARCHAR," + "eventDate TIMESTAMP," + "modified TIMESTAMP," + "scientificName VARCHAR," + "kingdom VARCHAR," + "family VARCHAR," + "locality VARCHAR," + "country VARCHAR," + "citation VARCHAR," + "decimalLatitude double precision," + "decimalLongitude double precision," + "coordinateUncertaintyInMeters VARCHAR," + "maxDepth double precision," + "minDepth double precision," + "basisOfRecord VARCHAR)";
            return sql;
        }
        logger.debug((Object)("hasHeader " + this.hasHeader));
        logger.debug((Object)("comment" + this.comment));
        ArrayList<String> sqltypes = new ArrayList<String>();
        logger.debug((Object)("Size column" + lineProcessor.firstColumns.size()));
        for (ArrayList<String> column : lineProcessor.firstColumns) {
            logger.debug((Object)"Print conlumn");
            sqltypes.add(CSVLineProcessorGeneric.getSqlType(column));
            logger.debug((Object)"add type ");
        }
        lineProcessor.addSqlType(sqltypes);
        List<String> cols = lineProcessor.getColsName();
        logger.debug((Object)("cols.size:" + cols.size()));
        logger.debug((Object)("addSqlType.size:" + lineProcessor.getSqlType().size()));
        logger.debug((Object)"Types:");
        String args = "";
        int i = 0;
        for (String colName : cols) {
            args = i >= lineProcessor.getSqlType().size() ? args + String.format("%s %s,", colName, "varchar") : args + String.format("%s %s,", colName, lineProcessor.getSqlType().get(i++));
            logger.debug((Object)("args" + args));
        }
        lineProcessor.getWellFormaFile(this.file);
        this.file = lineProcessor.getFile();
        logger.debug((Object)("***reassingned File path is " + this.file.getAbsolutePath()));
        String sql = "CREATE TABLE " + dbTableName + "(institutionCode VARCHAR," + "collectionCode VARCHAR," + "catalogueNumber VARCHAR," + "dataSet VARCHAR," + "dataProvider VARCHAR," + "dataSource VARCHAR," + "scientificNameAuthorship VARCHAR," + "identifiedBy VARCHAR," + "credits VARCHAR," + "recordedBy VARCHAR," + "eventDate TIMESTAMP," + "modified TIMESTAMP," + "scientificName VARCHAR," + "kingdom VARCHAR," + "family VARCHAR," + "locality VARCHAR," + "country VARCHAR," + "citation VARCHAR," + "decimalLatitude double precision," + "decimalLongitude double precision," + "coordinateUncertaintyInMeters VARCHAR," + "maxDepth double precision," + "minDepth double precision," + "basisOfRecord VARCHAR)";
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSqlStatmentCreateTimeSeriesSecondEdition(String dbTableName) throws Exception {
        CSVFileProcessor fp = new CSVFileProcessor();
        CSVLineProcessorTimeSeries lineProcessor = new CSVLineProcessorTimeSeries(this.delimiter);
        fp.setHasHeader(this.hasHeader);
        fp.setComment(this.comment);
        try {
            fp.processFile(this.file.getAbsolutePath(), (CSVLineProcessor)lineProcessor);
        }
        catch (NullPointerException e) {
            try {
                logger.debug((Object)"file finished before counted");
            }
            catch (Throwable throwable) {
                logger.debug((Object)("hasHeader " + this.hasHeader));
                logger.debug((Object)("comment" + this.comment));
                ArrayList<String> sqltypes = new ArrayList<String>();
                logger.debug((Object)("Size column" + lineProcessor.firstColumns.size()));
                for (ArrayList<String> column : lineProcessor.firstColumns) {
                    logger.debug((Object)"Print conlumn");
                    sqltypes.add(CSVLineProcessorTimeSeries.getSqlType(column));
                    logger.debug((Object)"added type ");
                }
                lineProcessor.addSqlType(sqltypes);
                List<String> cols = lineProcessor.getColsName();
                logger.debug((Object)("cols.size:" + cols.size()));
                logger.debug((Object)("addSqlType.size:" + lineProcessor.getSqlType().size()));
                logger.debug((Object)"Types:");
                logger.debug((Object)("hasHeader " + this.hasHeader));
                logger.debug((Object)("comment" + this.comment));
                String args = "";
                int i = 0;
                int indexTime = 0;
                boolean thereIstTimeColumn = false;
                for (String colName : cols) {
                    logger.debug((Object)("***COL name ***" + cols));
                    if (i >= lineProcessor.getSqlType().size()) {
                        args = args + String.format("%s %s,", colName, "varchar");
                    } else if (colName.equals("time")) {
                        logger.debug((Object)"***IS TIME ***");
                        args = args + String.format("%s %s,", colName, "timestamp without time zone");
                        thereIstTimeColumn = true;
                        indexTime = i++;
                    } else {
                        args = args + String.format("%s %s,", colName, lineProcessor.getSqlType().get(i++));
                    }
                    logger.debug((Object)("args" + args));
                }
                if (!thereIstTimeColumn) {
                    throw new Exception("There isn't the \"Time\" column in Timeseries dataset.");
                }
                lineProcessor.getWellFormaFile(this.file, indexTime);
                this.file = lineProcessor.getFile();
                logger.debug((Object)("***reassingned File path is " + this.file.getAbsolutePath()));
                String sql = String.format("CREATE TABLE %s ( %s )", dbTableName, args.substring(0, args.length() - 1));
                return sql;
            }
            logger.debug((Object)("hasHeader " + this.hasHeader));
            logger.debug((Object)("comment" + this.comment));
            ArrayList<String> sqltypes = new ArrayList<String>();
            logger.debug((Object)("Size column" + lineProcessor.firstColumns.size()));
            for (ArrayList<String> column : lineProcessor.firstColumns) {
                logger.debug((Object)"Print conlumn");
                sqltypes.add(CSVLineProcessorTimeSeries.getSqlType(column));
                logger.debug((Object)"added type ");
            }
            lineProcessor.addSqlType(sqltypes);
            List<String> cols = lineProcessor.getColsName();
            logger.debug((Object)("cols.size:" + cols.size()));
            logger.debug((Object)("addSqlType.size:" + lineProcessor.getSqlType().size()));
            logger.debug((Object)"Types:");
            logger.debug((Object)("hasHeader " + this.hasHeader));
            logger.debug((Object)("comment" + this.comment));
            String args = "";
            int i = 0;
            int indexTime = 0;
            boolean thereIstTimeColumn = false;
            for (String colName : cols) {
                logger.debug((Object)("***COL name ***" + cols));
                if (i >= lineProcessor.getSqlType().size()) {
                    args = args + String.format("%s %s,", colName, "varchar");
                } else if (colName.equals("time")) {
                    logger.debug((Object)"***IS TIME ***");
                    args = args + String.format("%s %s,", colName, "timestamp without time zone");
                    thereIstTimeColumn = true;
                    indexTime = i++;
                } else {
                    args = args + String.format("%s %s,", colName, lineProcessor.getSqlType().get(i++));
                }
                logger.debug((Object)("args" + args));
            }
            if (!thereIstTimeColumn) {
                throw new Exception("There isn't the \"Time\" column in Timeseries dataset.");
            }
            lineProcessor.getWellFormaFile(this.file, indexTime);
            this.file = lineProcessor.getFile();
            logger.debug((Object)("***reassingned File path is " + this.file.getAbsolutePath()));
            String sql = String.format("CREATE TABLE %s ( %s )", dbTableName, args.substring(0, args.length() - 1));
            return sql;
        }
        logger.debug((Object)("hasHeader " + this.hasHeader));
        logger.debug((Object)("comment" + this.comment));
        ArrayList<String> sqltypes = new ArrayList<String>();
        logger.debug((Object)("Size column" + lineProcessor.firstColumns.size()));
        for (ArrayList<String> column : lineProcessor.firstColumns) {
            logger.debug((Object)"Print conlumn");
            sqltypes.add(CSVLineProcessorTimeSeries.getSqlType(column));
            logger.debug((Object)"added type ");
        }
        lineProcessor.addSqlType(sqltypes);
        List<String> cols = lineProcessor.getColsName();
        logger.debug((Object)("cols.size:" + cols.size()));
        logger.debug((Object)("addSqlType.size:" + lineProcessor.getSqlType().size()));
        logger.debug((Object)"Types:");
        logger.debug((Object)("hasHeader " + this.hasHeader));
        logger.debug((Object)("comment" + this.comment));
        String args = "";
        int i = 0;
        int indexTime = 0;
        boolean thereIstTimeColumn = false;
        for (String colName : cols) {
            logger.debug((Object)("***COL name ***" + cols));
            if (i >= lineProcessor.getSqlType().size()) {
                args = args + String.format("%s %s,", colName, "varchar");
            } else if (colName.equals("time")) {
                logger.debug((Object)"***IS TIME ***");
                args = args + String.format("%s %s,", colName, "timestamp without time zone");
                thereIstTimeColumn = true;
                indexTime = i++;
            } else {
                args = args + String.format("%s %s,", colName, lineProcessor.getSqlType().get(i++));
            }
            logger.debug((Object)("args" + args));
        }
        if (!thereIstTimeColumn) {
            throw new Exception("There isn't the \"Time\" column in Timeseries dataset.");
        }
        lineProcessor.getWellFormaFile(this.file, indexTime);
        this.file = lineProcessor.getFile();
        logger.debug((Object)("***reassingned File path is " + this.file.getAbsolutePath()));
        String sql = String.format("CREATE TABLE %s ( %s )", dbTableName, args.substring(0, args.length() - 1));
        return sql;
    }

    private String getSqlStatmentCreateTimeSeries(String dbTableName) throws Exception {
        CSVFileProcessor fp = new CSVFileProcessor();
        CSVLineProcessorTimeSeries lineProcessor = new CSVLineProcessorTimeSeries(this.delimiter);
        fp.setHasHeader(this.hasHeader);
        fp.setComment(this.comment);
        try {
            fp.processFile(this.file.getAbsolutePath(), (CSVLineProcessor)lineProcessor);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!lineProcessor.isTimeFound()) {
            throw new Exception();
        }
        this.file = lineProcessor.getFile();
        logger.debug((Object)("hasHeader " + this.hasHeader));
        logger.debug((Object)("comment" + this.comment));
        List<String> cols = lineProcessor.getColsName();
        String args = "";
        int i = 0;
        for (String colName : cols) {
            args = i >= lineProcessor.getSqlType().size() ? args + String.format("%s %s,", colName, "varchar") : args + String.format("%s %s,", colName, lineProcessor.getSqlType().get(i++));
            logger.debug((Object)("args" + args));
        }
        String sql = String.format("CREATE TABLE %s ( %s )", dbTableName, args.substring(0, args.length() - 1));
        return sql;
    }

    private void printArray(List<String> a) {
        logger.debug((Object)a.toString());
    }
}

