/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.persistence;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;

public class RemoteStorage {
    private static GCUBELog logger = new GCUBELog(RemoteStorage.class);
    private IClient storage;

    public RemoteStorage(String userLogin, String scope) throws Exception {
        this.storage = new StorageClient(ServiceContext.class.getPackage().getName(), ServiceContext.SERVICE_NAME, userLogin, AccessType.SHARED, scope).getClient();
    }

    public String putFile(File file, String fileName) {
        String rfileName = File.separator + fileName;
        this.storage.put(true).LFile(file.getAbsolutePath()).RFile(rfileName);
        return this.storage.getUrl().RFile(rfileName);
    }

    public void putStream(InputStream is, String path) {
        this.storage.put(true).LFile(is).RFile(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String putObject(Object outputs) throws IOException {
        File file = File.createTempFile("output", "sm");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            XStream xstream = new XStream();
            xstream.toXML(outputs, (OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
        logger.debug((Object)("Create tmp file " + file.getAbsolutePath()));
        return this.putFile(file, UUID.randomUUID().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFile(String path) throws IOException {
        InputStream is = this.storage.get().RFileAStream(path);
        OutputStream out = null;
        try {
            File file = File.createTempFile("file", "sm");
            out = new FileOutputStream(file);
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = is.read(bytes)) != -1) {
                out.write(bytes, 0, read);
            }
            File file2 = file;
            return file2;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }
}

