/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.persistence;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;

public class DataBaseManager {
    private static GCUBELog logger = new GCUBELog(DataBaseManager.class);
    private static final String DRIVER = "org.postgresql.Driver";
    public static String URL;
    public static String USERNAME;
    public static String PASSWORD;
    private static GenericObjectPool connectionPool;
    private static DataSource dataSource;

    public static synchronized void initializeDataSource(String url, String username, String password) throws Exception {
        URL = url;
        USERNAME = username;
        PASSWORD = password;
        Class.forName(DRIVER).newInstance();
        connectionPool = new GenericObjectPool();
        connectionPool.setMaxActive(10);
        DriverManagerConnectionFactory cf = new DriverManagerConnectionFactory(URL, USERNAME, PASSWORD);
        PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)cf, (ObjectPool)connectionPool, null, null, false, true);
        dataSource = new PoolingDataSource(pcf.getPool());
    }

    public static DataSource getDataSource() throws Exception {
        if (dataSource == null) {
            throw new StatisticalManagerException("Data source not initialized ");
        }
        return dataSource;
    }

    public static String getUrlDB() {
        return URL;
    }

    public static String getDriver() {
        return DRIVER;
    }

    public static String getUsername() {
        return USERNAME;
    }

    public static String getPassword() {
        return PASSWORD;
    }

    public static void closeConn(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void rollback(Connection conn) {
        try {
            if (conn != null) {
                conn.rollback();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeStatement(Statement stm) {
        try {
            if (stm != null) {
                stm.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTable(String tableId) throws Exception {
        Connection conn = DataBaseManager.getDataSource().getConnection();
        Statement stmt = null;
        try {
            String sql = "DROP TABLE " + tableId;
            System.out.println(sql);
            stmt = conn.createStatement();
            stmt.executeUpdate(sql);
        }
        catch (Throwable throwable) {
            DataBaseManager.closeStatement(stmt);
            DataBaseManager.closeConn(conn);
            throw throwable;
        }
        DataBaseManager.closeStatement(stmt);
        DataBaseManager.closeConn(conn);
    }
}

