/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.DataTypeRecognizer;
import org.gcube.data.analysis.statisticalmanager.dataspace.importer.CSVAbstractLineProcessor;

public class CSVLineProcessorTimeSeries
extends CSVAbstractLineProcessor {
    private int indexTime = -1;
    private boolean toContinue = true;
    public ArrayList<ArrayList<String>> firstColumns = new ArrayList();
    private boolean stop = true;
    private int count = 0;
    private File file = File.createTempFile("TimeSeries", "csv");
    int maxIteration = 10;
    private static GCUBELog logger = new GCUBELog(CSVLineProcessorTimeSeries.class);
    ArrayList<String> types;

    public CSVLineProcessorTimeSeries(String separator) throws IOException {
        super(separator);
    }

    public boolean continueProcessing() {
        return this.toContinue;
    }

    private int getIndexTime() {
        if (this.indexTime != -1) {
            return this.indexTime;
        }
        int i = 0;
        for (String value : this.getColsName()) {
            System.out.println("field " + value);
            if (value.toLowerCase().equals("time")) {
                this.indexTime = i;
            }
            ++i;
        }
        return this.indexTime;
    }

    @Override
    public void processDataLine(int arg0, List<String> fields) {
        super.processDataLine(arg0, fields);
        if (this.count >= this.maxIteration) {
            this.stop = false;
        } else {
            if (fields != null) {
                ArrayList<String> ar = new ArrayList<String>(fields);
                this.printArray(ar);
                String fieldValue = ar.get(0);
                List<String> elements = null;
                elements = this.separator.equals(",") ? fields : Arrays.asList(fieldValue.split(this.separator));
                this.printArray(elements);
                int ncolumns = elements.size();
                logger.debug((Object)("number of columns are" + ncolumns));
                for (int i = 0; i < ncolumns; ++i) {
                    logger.debug((Object)("i: " + i));
                    String element = elements.get(i);
                    logger.debug((Object)("element :" + element));
                    logger.debug((Object)("count " + this.count));
                    if (i >= this.firstColumns.size()) {
                        ArrayList<String> newer = new ArrayList<String>();
                        newer.add(element);
                        this.firstColumns.add(newer);
                    } else {
                        this.firstColumns.get(i).add(element);
                    }
                    logger.debug((Object)("in the column " + i + "put element" + element));
                }
            }
            ++this.count;
        }
    }

    private void printArray(List<String> a) {
        for (String ar : a) {
            logger.debug((Object)ar);
            logger.debug((Object)"****");
        }
    }

    public static String getSqlType(ArrayList<String> values) {
        String className = DataTypeRecognizer.guessType(values);
        String sqlType = null;
        if (String.class.getName().equals(className)) {
            sqlType = "varchar";
        }
        if (Boolean.class.getName().equals(className)) {
            sqlType = "boolean";
        }
        if (BigDecimal.class.getName().equals(className)) {
            sqlType = "double precision";
        }
        return sqlType;
    }

    private String getSQLType(String value) {
        String sqlType = null;
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        String className = DataTypeRecognizer.guessType(values);
        if (String.class.getName().equals(className)) {
            sqlType = "varchar";
        }
        if (Boolean.class.getName().equals(className)) {
            sqlType = "boolean";
        }
        if (BigDecimal.class.getName().equals(className)) {
            sqlType = "double precision";
        }
        return sqlType;
    }

    public boolean isTimeFound() {
        return this.indexTime != -1;
    }

    public File getFile() {
        return this.file;
    }
}

