/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;
import org.gcube.common.core.utils.logging.GCUBELog;

public abstract class CSVAbstractLineProcessor
implements CSVLineProcessor {
    private static GCUBELog logger = new GCUBELog(CSVAbstractLineProcessor.class);
    private static final String FIELD = "field";
    private boolean stopFieldName = false;
    protected List<String> colNames = new ArrayList<String>();
    protected List<String> sqlTypes = new ArrayList<String>();
    protected String separator;
    private boolean quote = false;

    public CSVAbstractLineProcessor(String separator) {
        this.separator = separator;
    }

    protected String formattedString(String refactorStrings) {
        logger.debug((Object)"formattedString method");
        logger.debug((Object)("string in input" + refactorStrings));
        ArrayList<String> ar = new ArrayList<String>(Arrays.asList(refactorStrings.split("\"")));
        String result = new String();
        for (int i = 0; i < ar.size(); ++i) {
            if (i % 2 == 0) {
                result.concat(ar.get(i));
                continue;
            }
            String tmp = ar.get(i).replace(this.separator, " ");
            result.concat(tmp);
        }
        logger.debug((Object)("result" + result));
        return result;
    }

    public void processDataLine(int arg0, List<String> fieldValues) {
        if (this.separator.equals("|")) {
            this.separator = "\\|";
        }
        if (this.separator.equals(".")) {
            this.separator = "\\.";
        }
        if (!this.separator.equals(",")) {
            String support = new String();
            for (String s : fieldValues) {
                support = support + s;
            }
            logger.debug((Object)("Support" + support));
            fieldValues.clear();
            fieldValues.add(support);
            this.printArray(fieldValues);
        }
        if (!this.colNames.isEmpty() || this.stopFieldName) {
            return;
        }
        for (int i = 0; i < fieldValues.size(); ++i) {
            String fieldValue = fieldValues.get(i);
            logger.debug((Object)("fieldValue:" + fieldValue));
            String[] values = fieldValue.split(this.separator);
            int j = 0;
            if (!this.separator.equals(",")) {
                for (String value : values) {
                    if (!this.quote) {
                        logger.debug((Object)("Value:" + value));
                        this.colNames.add(FIELD + (j + i));
                        ++j;
                    }
                    if (!value.startsWith("\"") && !value.startsWith("'")) continue;
                    this.quote = !this.quote;
                }
                continue;
            }
            this.colNames.add(FIELD + i);
        }
        this.stopFieldName = true;
    }

    public void processHeaderLine(int arg0, List<String> fieldNames) {
        for (String fieldName : fieldNames) {
            String[] values;
            for (String value : values = fieldName.split(this.separator)) {
                this.colNames.add(value);
            }
        }
    }

    public List<String> getColsName() {
        return this.colNames;
    }

    public List<String> getSqlType() {
        return this.sqlTypes;
    }

    private void printArray(List<String> a) {
        for (String ar : a) {
            logger.debug((Object)ar);
            logger.debug((Object)"****");
        }
    }

    public void addSqlType(ArrayList<String> values) {
        if (values != null) {
            this.sqlTypes.addAll(values);
        }
    }
}

