package org.gcube.data.analysis.statisticalmanager.experimentspace;

import javax.jms.JMSException;

import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.access.queueManager.QueueItemHandler;
import org.gcube.data.access.queueManager.QueueType;
import org.gcube.data.access.queueManager.impl.QueueConsumerFactory;
import org.gcube.data.access.queueManager.model.RequestItem;
import org.gcube.data.analysis.statisticalmanager.experimentspace.computation.ComputationContext;
import org.gcube.data.analysis.statisticalmanager.experimentspace.computation.ComputationResource;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationRequest;

public class ServiceQueueConsumer implements QueueItemHandler<RequestItem> {

	private static GCUBELog logger = new GCUBELog(ServiceQueueConsumer.class);
	private QueueConsumerFactory consumerFactory;
	
	public ServiceQueueConsumer(QueueConsumerFactory consumerFactory) {
		this.consumerFactory = consumerFactory;
	}

	@Override
	public void handleQueueItem(RequestItem item) throws Exception {

		logger.debug("Message received" + item.getId());

		SMComputationRequest request = (SMComputationRequest) item
				.getParameters().get(ComputationFactoryResource.MESSAGE_REQUEST);

		String computationId = (String)item.getParameters().get(
				ComputationFactoryResource.MESSAGE_COMPUTATION_ID);
		logger.debug("ComputationId " + computationId);
		GCUBEStatefulPortTypeContext stfctx = ComputationContext.getContext();
		
		logger.debug("User" + request.getUser());
		
		GCUBEWSResourceKey key = stfctx.makeKey(request.getUser());
		String scope = (String) item.getParameters().get(ComputationFactoryResource.MESSAGE_SCOPE);
		logger.debug("**************************Scope "+ scope);
		
		ComputationContext.getContext().getServiceContext()
		.setScope(Thread.currentThread(), GCUBEScope.getScope(scope));

		ComputationResource wsResource = (ComputationResource) ComputationContext
				.getContext().getWSHome().create(key, request.getUser(), scope);

		logger.debug("Resource created");
		wsResource.executeComputation(request.getConfig(), Long.parseLong(computationId));
	}

	@Override
	public void close() {

	}
	
	private void retryToConnect() {
		try {
			consumerFactory.close();
			consumerFactory.register(ComputationFactoryResource.SERVICE, QueueType.REQUEST,this);
		} catch (JMSException e) {
			logger.error("Consumer connection exception ....retry to connect",e);
			try {
				Thread.sleep(3000);
			} catch (InterruptedException e1) {
				logger.error("Consumer wait time to connect error",e);
			}
			retryToConnect();
		}
	}

	
	public void onException(JMSException arg0) {
		logger.debug("Consumer connection exception ....retry to connect",arg0);
		retryToConnect();
	}

}
