/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.experimentspace.computation;

import com.thoughtworks.xstream.XStream;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.data.analysis.statisticalmanager.SMOperationType;
import org.gcube.data.analysis.statisticalmanager.SMResourceType;
import org.gcube.data.analysis.statisticalmanager.persistence.SMPersistenceManager;
import org.gcube.data.analysis.statisticalmanager.util.ServiceUtil;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMFile;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMObject;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMResource;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTable;

public class BuilderComputationOutput {
    private static GCUBELog logger = new GCUBELog(BuilderComputationOutput.class);
    private String portalLogin;
    private String scope;
    private SMComputation computation;

    public BuilderComputationOutput(String portalLogin, String scope, SMComputation computation) {
        this.portalLogin = portalLogin;
        this.scope = scope;
        this.computation = computation;
    }

    private SMTable serializeTabular(OutputTable output) throws Exception {
        String template = ((TableTemplates)output.getTemplateNames().get(0)).toString();
        SMTable table = new SMTable(template);
        table.setPortalLogin(this.portalLogin);
        table.setAlgorithm(this.computation.getAlgorithm());
        table.setResourceType(SMResourceType.TABULAR.ordinal());
        table.setResourceId(output.getTableName());
        table.setDescription(output.getDescription());
        table.setName(output.getName());
        table.setProvenance(SMOperationType.COMPUTED.ordinal());
        table.setCreationDate(Calendar.getInstance());
        table.setOperationId(this.computation.getOperationId());
        SMPersistenceManager.addCreatedResource((SMResource)table);
        return table;
    }

    private SMFile serializeFile(PrimitiveType output) throws Exception {
        logger.debug((Object)"---------- serialize File ");
        WorkspaceFolder appFolder = ServiceUtil.getWorkspaceSMFolder(this.portalLogin);
        logger.debug((Object)"---------- created application folder ");
        File outputFile = (File)output.getContent();
        FileInputStream inputStream = new FileInputStream(outputFile);
        String fileName = output.getName() + ServiceUtil.getDateTime();
        logger.debug((Object)("---------- fileName : " + fileName));
        ExternalFile f = appFolder.createExternalFileItem(fileName, output.getDescription(), null, (InputStream)inputStream);
        String url = f.getPublicLink();
        SMFile file = new SMFile("mimeType", fileName, url);
        file.setPortalLogin(this.portalLogin);
        file.setAlgorithm(this.computation.getAlgorithm());
        file.setResourceType(SMResourceType.FILE.ordinal());
        file.setResourceId(UUID.randomUUID().toString());
        file.setDescription(output.getDescription());
        file.setName(outputFile.getName());
        file.setProvenance(SMOperationType.IMPORTED.ordinal());
        file.setCreationDate(Calendar.getInstance());
        file.setOperationId(this.computation.getOperationId());
        SMPersistenceManager.addCreatedResource((SMResource)file);
        return file;
    }

    private SMObject serializePrimitiveObject(PrimitiveType primitiveObject) {
        switch (primitiveObject.getType()) {
            case STRING: {
                SMObject object = new SMObject((String)primitiveObject.getContent());
                object.setPortalLogin(this.portalLogin);
                object.setAlgorithm(this.computation.getAlgorithm());
                object.setName(PrimitiveTypes.STRING.toString());
                object.setResourceType(SMResourceType.OBJECT.ordinal());
                object.setDescription(primitiveObject.getDescription());
                object.setProvenance(SMOperationType.COMPUTED.ordinal());
                object.setCreationDate(Calendar.getInstance());
                object.setOperationId(this.computation.getOperationId());
                return object;
            }
        }
        return null;
    }

    private SMObject serializeImage(PrimitiveType primitiveObject) throws Exception {
        logger.debug((Object)"---------- serialize Image ");
        WorkspaceFolder appFolder = ServiceUtil.getWorkspaceSMFolder(this.portalLogin);
        logger.debug((Object)"---------- create application folder ");
        Map map = (Map)primitiveObject.getContent();
        String folderName = primitiveObject.getName() + ServiceUtil.getDateTime();
        logger.debug((Object)("---------- folder name " + folderName));
        WorkspaceFolder subFolder = appFolder.createFolder(folderName, "SM Image");
        String dirName = File.separator + folderName;
        for (Map.Entry entry : map.entrySet()) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)ImageTools.toBufferedImage((Image)((Image)entry.getValue())), "png", os);
            ExternalImage f = subFolder.createExternalImageItem((String)entry.getKey(), primitiveObject.getDescription(), "png", (InputStream)new ByteArrayInputStream(os.toByteArray()));
        }
        logger.debug((Object)"---------- added File ");
        SMObject resource = new SMObject(subFolder.getPath());
        resource.setPortalLogin(this.portalLogin);
        resource.setResourceType(SMResourceType.OBJECT.ordinal());
        resource.setResourceId(UUID.randomUUID().toString());
        resource.setName(PrimitiveTypes.IMAGES.toString());
        resource.setDescription(primitiveObject.getDescription());
        resource.setProvenance(SMOperationType.COMPUTED.ordinal());
        resource.setCreationDate(Calendar.getInstance());
        resource.setOperationId(this.computation.getOperationId());
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SMObject serializeMap(PrimitiveType primitiveObject) throws Exception {
        Map map = (Map)primitiveObject.getContent();
        LinkedHashMap outputs = new LinkedHashMap();
        for (Map.Entry entry : map.entrySet()) {
            SMResource resource = this.serialize((StatisticalType)entry.getValue());
            outputs.put(entry.getKey(), resource);
        }
        File file = File.createTempFile("output", "sm");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            XStream xstream = new XStream();
            xstream.toXML(outputs, (OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
        logger.debug((Object)("Create tmp file " + file.getAbsolutePath()));
        WorkspaceFolder appFolder = ServiceUtil.getWorkspaceSMFolder(this.portalLogin);
        FileInputStream inputStream = new FileInputStream(file);
        String fileName = primitiveObject.getName() + ServiceUtil.getDateTime();
        logger.debug((Object)("---------- filename " + fileName));
        ExternalFile f = appFolder.createExternalFileItem(fileName, primitiveObject.getDescription(), null, (InputStream)inputStream);
        String url = f.getPublicLink();
        SMObject resource = new SMObject(url);
        resource.setPortalLogin(this.portalLogin);
        resource.setResourceType(SMResourceType.OBJECT.ordinal());
        resource.setResourceId(UUID.randomUUID().toString());
        resource.setName(PrimitiveTypes.MAP.toString());
        resource.setDescription(primitiveObject.getDescription());
        resource.setProvenance(SMOperationType.COMPUTED.ordinal());
        resource.setCreationDate(Calendar.getInstance());
        resource.setOperationId(this.computation.getOperationId());
        return resource;
    }

    public SMResource serialize(StatisticalType object) throws Exception {
        if (object instanceof OutputTable) {
            return this.serializeTabular((OutputTable)object);
        }
        if (object instanceof PrimitiveType) {
            PrimitiveType primitiveObject = (PrimitiveType)object;
            if (primitiveObject.getType() == PrimitiveTypes.MAP) {
                return this.serializeMap(primitiveObject);
            }
            if (primitiveObject.getType() == PrimitiveTypes.IMAGES) {
                return this.serializeImage(primitiveObject);
            }
            if (primitiveObject.getType() == PrimitiveTypes.FILE) {
                return this.serializeFile(primitiveObject);
            }
            return this.serializePrimitiveObject(primitiveObject);
        }
        logger.error((Object)"throw Exception into serialize resource");
        throw new Exception();
    }
}

