/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactory;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactoryResource;
import org.gcube.data.analysis.statisticalmanager.experimentspace.FactoryComputationParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.SMGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMListGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMTypeParameter;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.processing.factories.ProcessorsFactory;

public class ServiceUtil {
    private static GCUBELog logger = new GCUBELog(ServiceUtil.class);

    public static SMListGroupedAlgorithms getGroupedAlgorithm(SMTypeParameter[] param, HashMap<String, List<String>> mapFeatures) throws Exception {
        ArrayList<SMGroupedAlgorithms> features = new ArrayList<SMGroupedAlgorithms>();
        for (Map.Entry<String, List<String>> entry : mapFeatures.entrySet()) {
            logger.debug((Object)("User Category " + entry.getKey()));
            SMGroupedAlgorithms feature = new SMGroupedAlgorithms();
            feature.setCategory(entry.getKey());
            ArrayList<SMAlgorithm> algorithms = new ArrayList<SMAlgorithm>();
            for (String algorithmName : entry.getValue()) {
                String algorithmCategory = ServiceUtil.getAlgorithmCategory(algorithmName);
                logger.debug((Object)("Computer category " + algorithmCategory));
                List<StatisticalType> parameters = ComputationFactory.getFactoryResource().getListParameters(algorithmCategory, algorithmName);
                String description = ComputationFactory.getFactoryResource().getAgorithmDescription(algorithmCategory, algorithmName);
                if (param == null || param.length == 0) {
                    algorithms.add(new SMAlgorithm(algorithmCategory, description, algorithmName));
                    continue;
                }
                SMTypeParameter[] sMTypeParameterArray = param;
                int n = param.length;
                int n2 = 0;
                while (n2 < n) {
                    SMTypeParameter typeParameter = sMTypeParameterArray[n2];
                    if (FactoryComputationParameter.containParameter(typeParameter, parameters)) {
                        algorithms.add(new SMAlgorithm(algorithmCategory, description, algorithmName));
                    }
                    ++n2;
                }
            }
            if (algorithms.isEmpty()) continue;
            feature.setList(algorithms.toArray(new SMAlgorithm[algorithms.size()]));
            features.add(feature);
        }
        return new SMListGroupedAlgorithms(features.toArray(new SMGroupedAlgorithms[features.size()]));
    }

    public static String getAlgorithmCategory(String algorithmUser) throws Exception {
        String configPath = ComputationFactoryResource.getConfigPath();
        HashMap mapFeatures = ProcessorsFactory.getAllFeatures((String)configPath);
        for (Map.Entry entry : mapFeatures.entrySet()) {
            List algorithms = (List)entry.getValue();
            for (String algorithm : algorithms) {
                if (!algorithm.equals(algorithmUser)) continue;
                return (String)entry.getKey();
            }
        }
        logger.error((Object)"Computation agent category not found");
        throw new Exception("Computation agent category not found");
    }
}

