/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.DataTypeRecognizer;
import org.gcube.data.analysis.statisticalmanager.dataspace.importer.CSVAbstractLineProcessor;

public class CSVLineProcessorGeneric
extends CSVAbstractLineProcessor {
    private boolean stop = true;
    private int count = 0;
    private Map<String, List<String>> map;

    public CSVLineProcessorGeneric(String separator) {
        super(separator);
    }

    public boolean continueProcessing() {
        return this.stop;
    }

    @Override
    public void processDataLine(int arg0, List<String> fields) {
        super.processDataLine(arg0, fields);
        for (String fieldValue : fields) {
            if (fieldValue != null) {
                String[] stringArray = fieldValue.split(this.separator);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    String sqlType = this.getSqlType(value);
                    this.sqlTypes.add(sqlType);
                    ++n2;
                }
                continue;
            }
            this.sqlTypes.add("varchar");
        }
        this.stop = false;
    }

    private String getSqlType(String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        String className = DataTypeRecognizer.guessType(values);
        String sqlType = null;
        if (String.class.getName().equals(className)) {
            sqlType = "varchar";
        }
        if (Boolean.class.getName().equals(className)) {
            sqlType = "boolean";
        }
        if (BigDecimal.class.getName().equals(className)) {
            sqlType = "double precision";
        }
        return sqlType;
    }
}

