package org.gcube.data.analysis.statisticalmanager.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map.Entry;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactory;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactoryResource;
import org.gcube.data.analysis.statisticalmanager.experimentspace.FactoryComputationParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.SMGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMListGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMTypeParameter;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.processing.factories.ProcessorsFactory;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationalAgentClass;



public class ServiceUtil {

	private static GCUBELog logger = new GCUBELog(ServiceUtil.class);
	
	public static SMListGroupedAlgorithms getGroupedAlgorithm(SMTypeParameter[] param, HashMap<String,List<String>> mapFeatures) throws Exception {

		
		ArrayList<SMGroupedAlgorithms> features = new ArrayList<SMGroupedAlgorithms>();

		for (Entry<String,List<String>> entry : mapFeatures.entrySet()) {
			
			// Set category request
			logger.debug("User Category " + entry.getKey());
			
			SMGroupedAlgorithms feature = new SMGroupedAlgorithms();
			feature.setCategory(entry.getKey());
			
			ArrayList<SMAlgorithm> algorithms = new ArrayList<SMAlgorithm>();
			
			for (String algorithmName : entry.getValue()){
				
				
				// Retrieve computational agent category
				String algorithmCategory = getAlgorithmCategory(algorithmName);
				logger.debug("Computer category " + algorithmCategory);
				
				List<StatisticalType> parameters =  ComputationFactory.getFactoryResource().
						getListParameters(algorithmCategory, algorithmName);

				String description = ComputationFactory.getFactoryResource().
						getAgorithmDescription(algorithmCategory, algorithmName);
				
				if (param == null || (param.length == 0)) {	
					algorithms.add(new SMAlgorithm(algorithmCategory, description, algorithmName));
				} else {
					for (SMTypeParameter typeParameter : param) {
						if (FactoryComputationParameter.containParameter(typeParameter, parameters)){
							algorithms.add(new SMAlgorithm(algorithmCategory, description, algorithmName));
						}
					}
				}
			}

			if (!algorithms.isEmpty()) {
				feature.setList(algorithms.toArray(new SMAlgorithm[algorithms.size()]));
				features.add(feature);
			}
		}

		return new SMListGroupedAlgorithms(features.toArray(new SMGroupedAlgorithms[features.size()]));
	}
	
	public static String getAlgorithmCategory(String algorithmUser) throws Exception {
		
		String configPath = ComputationFactoryResource.getConfigPath();
		HashMap<String,List<String>> mapFeatures = ProcessorsFactory.getAllFeatures(configPath);
		for (Entry<String,List<String>> entry : mapFeatures.entrySet()) {
			List<String> algorithms = entry.getValue();
			for (String algorithm : algorithms){
				if (algorithm.equals(algorithmUser))
					return entry.getKey();
			}
			
			
		}
		
		logger.error("Computation agent category not found");
		throw new Exception("Computation agent category not found");
	}
	 

}
