package org.gcube.data.analysis.statisticalmanager.persistence;

import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.AccessPoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;



public class RuntimeResourceManager {
	
	private static GCUBELog logger = new GCUBELog(RuntimeResourceManager.class);

	private static final String RUNTIME_RESOURCE_DB = "StatisticalManagerDataBase";
	
	public static void initializeDataBase() throws Exception {
		
		
		 SimpleQuery query = queryFor(ServiceEndpoint.class);	
		 query.addCondition("$resource/Profile/Name/text() eq '" + RUNTIME_RESOURCE_DB + "'");
		 DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);
	
		 Map<String, GCUBEScope> scopes = ServiceContext.getContext().getInstance().getScopes();
		 List<ServiceEndpoint> resources = null;
		 for(Entry<String, GCUBEScope> scope : scopes.entrySet()) {
			 
			 ScopeProvider.instance.set(scope.getValue().toString());
			 resources = client.submit(query);
			 if (resources != null && !resources.isEmpty())
				 break;
			 
		 }
		 
		if(resources == null || resources.isEmpty())
			throw new StatisticalManagerException("Runtime resource " + RUNTIME_RESOURCE_DB + " not found");
		
		ServiceEndpoint resource = resources.get(0);
		if (resource.profile().accessPoints() == null ||  resource.profile().accessPoints().isEmpty()) 
			throw new StatisticalManagerException("Accesspoint in resource " + RUNTIME_RESOURCE_DB + " not found");

		for (AccessPoint ap : resource.profile().accessPoints()) {
			
			logger.debug("Access point name " + ap.name());
			
			
			if (ap.name().equals("jdbc")) {
				
				logger.debug("URL jdbc  " + ap.address());
				logger.debug("User jdbc " + ap.username());
				logger.debug("Pass jdbc " + StringEncrypter.getEncrypter().decrypt(ap.password()));
				
				DataBaseManager.initializeDataSource(ap.address(),
						ap.username(), StringEncrypter.getEncrypter().decrypt(ap.password()));
			}
			
			if (ap.name().equals("hibernate")) {
				logger.debug("URL hibernate  " + ap.address());
				logger.debug("User hibernate " + ap.username());
				logger.debug("Pass hibernate " + StringEncrypter.getEncrypter().decrypt(ap.password()));
				
				HibernateManager.buildSessionFactory(ap.address(),
						ap.username(), StringEncrypter.getEncrypter().decrypt(ap.password()));
				
			}
		}
	}

	public static Group<AccessPoint> getRRAccessPoint(String runtimeResource) throws Exception{

		 SimpleQuery query = queryFor(ServiceEndpoint.class);	
		 query.addCondition("$resource/Profile/Name/text() eq '" + runtimeResource + "'");
		 DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);
	
		 Map<String, GCUBEScope> scopes = ServiceContext.getContext().getInstance().getScopes();
		 List<ServiceEndpoint> resources = null;
		 for(Entry<String, GCUBEScope> scope : scopes.entrySet()) {
			 
			 ScopeProvider.instance.set(scope.getValue().toString());
			 resources = client.submit(query);
			 if (resources != null && !resources.isEmpty())
				 break;
			 
		 }
		 
		if(resources == null || resources.isEmpty())
			throw new StatisticalManagerException("Runtime resource " + runtimeResource + " not found");
		
		ServiceEndpoint resource = resources.get(0);
		if (resource.profile().accessPoints() == null ||  resource.profile().accessPoints().isEmpty()) 
			throw new StatisticalManagerException("Accesspoint in resource " + runtimeResource + " not found");


		return resource.profile().accessPoints();
	}


}
