package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import org.gcube.contentmanagement.graphtools.utils.DateGuesser;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.DataTypeRecognizer;


public class CSVLineProcessorTimeSeries extends CSVAbstractLineProcessor{


	private int indexTime = -1;
	private boolean toContinue = true;

	private File file;  
	
	
	public CSVLineProcessorTimeSeries(String separator) throws IOException {
		super(separator);
		
		file = File.createTempFile("TimeSeries", "csv");
		// TODO Auto-generated constructor stub
	}
	
	@Override
	public boolean continueProcessing() {
		return toContinue;
	}
	
	private int getIndexTime() {
		
		if(indexTime != -1)
			return indexTime;
		
		int i = 0;
		for (String value : getColsName()) {
			System.out.println("field " + value);
			if (value.toLowerCase().equals("time"))
				indexTime = i;
			i++;
		}
		return indexTime;
	}

	@Override
	public void processDataLine(int arg0, List<String> fields) {
		
		try {
			FileWriter fstream = new FileWriter(file, true);
			BufferedWriter out = new BufferedWriter(fstream);
			for (int i = 0; i < fields.size(); i++) {
				String fieldValue = fields.get(i);
				
				if (separator.equals(",")) {
					if (i == getIndexTime())
						sqlTypes.add("timestamp without time zone");
					else {
						
						String sqlType = getSQLType(fieldValue);
						sqlTypes.add(sqlType);
					}
					
					if (i == getIndexTime()) {
						
						Calendar calendar = DateGuesser.convertDate(fieldValue);
						SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
						String timeValue = sdf.format(calendar.getTime());
													
						timeValue = (i == fields.size() - 1)?timeValue:timeValue + ",";
						out.write(timeValue);
						
					} else {					
						String cleanedValue = (fieldValue.contains(","))?"\"" + fieldValue + "\"":fieldValue;
						cleanedValue = (i == fields.size() - 1)?cleanedValue:cleanedValue + ",";
						out.write(cleanedValue);
					}
				} else {
					int j = 0;
					for(String value : fieldValue.split(separator)) {
						if (j == getIndexTime())
							sqlTypes.add("timestamp without time zone");
						else {
							String sqlType = getSQLType(value);
							sqlTypes.add(sqlType);
							j++;
						}
						out.write(fieldValue + ",");
					}
				}
			}
			out.write("\n");
			out.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}

	private String getSQLType(String value) {
		
		String sqlType = null;
		ArrayList<String> values = new ArrayList<String>();
		values.add(value);

		String className = DataTypeRecognizer.guessType(values);

		if (String.class.getName().equals(className)) {
			sqlType = "varchar";
		}						
		if(Boolean.class.getName().equals(className)) {
			sqlType = "boolean";
		}		

		if(BigDecimal.class.getName().equals(className)) {
			sqlType = "double precision";
		}
		
		return sqlType;
	}

	public boolean isTimeFound() {
		return indexTime!= -1;
	}
	
	public File getFile() {
		return file;
	}

}
