package org.gcube.data.analysis.statisticalmanager.dataspace.importer;


import java.util.ArrayList;
import java.util.List;


import net.sf.csv4j.CSVLineProcessor;

public abstract class CSVAbstractLineProcessor implements CSVLineProcessor{
	
	private static final String FIELD = "field";
	
	private boolean stopFieldName = false;
	protected List<String> colNames = new ArrayList<String>();
	protected List<String> sqlTypes = new ArrayList<String>();
	protected String separator;
	private boolean quote = false;
	
	public CSVAbstractLineProcessor(String separator) {
		
		this.separator = separator;
	}
	
	
	@Override
	public void processDataLine(int arg0, List<String> fieldValues) {
		
		if (!colNames.isEmpty() || stopFieldName)
			return;
		
		for (int i = 0; i < fieldValues.size(); i++) {
			String fieldValue = fieldValues.get(i);			
			String[] values = fieldValue.split(separator);
			
			int j = 0;
			if (!separator.equals(",")){
				for (String value : values) {
					if (!quote) {
						colNames.add(FIELD + (j + i));
						j++;
					}
					if (value.startsWith("\"") || value.startsWith("'")) {
						quote = !(quote);
					}

				}
			} else {
				colNames.add(FIELD + i);
			}
		}
		stopFieldName = true;	
	}

	@Override
	public void processHeaderLine(int arg0, List<String> fieldNames) {	
		for ( String fieldName : fieldNames ) {		
			String[] values = fieldName.split(separator);
			for(String value : values) {
				colNames.add(value);
			}			
		}
	}
	
	public List<String> getColsName() {
		return colNames;
	}
	
	public List<String> getSqlType() {
		return sqlTypes;
	}

}
