/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.util.ArrayList;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;

public abstract class CSVAbstractLineProcessor
implements CSVLineProcessor {
    private static final String FIELD = "field";
    private boolean stopFieldName = false;
    protected List<String> colNames = new ArrayList<String>();
    protected List<String> sqlTypes = new ArrayList<String>();
    protected String separator;
    private boolean quote = false;

    public CSVAbstractLineProcessor(String separator) {
        this.separator = separator;
    }

    public void processDataLine(int arg0, List<String> fieldValues) {
        if (!this.colNames.isEmpty() || this.stopFieldName) {
            return;
        }
        int i = 0;
        while (i < fieldValues.size()) {
            String fieldValue = fieldValues.get(i);
            String[] values = fieldValue.split(this.separator);
            int j = 0;
            if (!this.separator.equals(",")) {
                String[] stringArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    if (!this.quote) {
                        this.colNames.add(FIELD + (j + i));
                        ++j;
                    }
                    if (value.startsWith("\"") || value.startsWith("'")) {
                        this.quote = !this.quote;
                    }
                    ++n2;
                }
            } else {
                this.colNames.add(FIELD + i);
            }
            ++i;
        }
        this.stopFieldName = true;
    }

    public void processHeaderLine(int arg0, List<String> fieldNames) {
        for (String fieldName : fieldNames) {
            String[] values;
            String[] stringArray = values = fieldName.split(this.separator);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                this.colNames.add(value);
                ++n2;
            }
        }
    }

    public List<String> getColsName() {
        return this.colNames;
    }

    public List<String> getSqlType() {
        return this.sqlTypes;
    }
}

