/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.persistence;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.SMOperationStatus;
import org.gcube.data.analysis.statisticalmanager.SMOperationType;
import org.gcube.data.analysis.statisticalmanager.SMResourceType;
import org.gcube.data.analysis.statisticalmanager.persistence.DataBaseManager;
import org.gcube.data.analysis.statisticalmanager.persistence.HibernateManager;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputations;
import org.gcube.data.analysis.statisticalmanager.stubs.SMCreateTableRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMImporters;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMAbstractResource;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMEntries;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMEntry;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMImport;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMOperation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMResource;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMSystemImport;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTableMetadata;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.transform.Transformers;

public class SMPersistenceManager {
    private static GCUBELog logger = new GCUBELog(SMPersistenceManager.class);

    public static long addImporter(SMCreateTableRequest request) throws Exception {
        Session session = HibernateManager.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMImport smimport = new SMImport();
            smimport.setFileName(request.getTableName());
            smimport.setObjectType(request.getTableType());
            smimport.setOperationType(SMOperationType.IMPORTED.ordinal());
            smimport.setChecked(false);
            smimport.setPortalLogin(request.getUser());
            smimport.setSubmissionDate(Calendar.getInstance());
            smimport.setDescription(request.getDescription());
            smimport.setOperationStatus(SMOperationStatus.RUNNING.ordinal());
            session.save((Object)smimport);
            t.commit();
            long l = smimport.getOperationId();
            return l;
        }
        catch (Exception e) {
            HibernateManager.roolbackTransaction(t);
            throw new Exception();
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public static long addSystemImporter(String description, SMResource resource) throws Exception {
        Session session = HibernateManager.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMSystemImport smimport = new SMSystemImport();
            smimport.setOperationType(SMOperationType.SYSTEM.ordinal());
            smimport.setSubmissionDate(Calendar.getInstance());
            smimport.setDescription(description);
            session.save((Object)resource);
            SMAbstractResource ar = new SMAbstractResource();
            ar.setResource(resource);
            ar.setAbstractResourceId(resource.getResourceId());
            session.save((Object)ar);
            smimport.setAbstractResource(ar);
            smimport.setOperationStatus(SMOperationStatus.COMPLETED.ordinal());
            smimport.setCompletedDate(Calendar.getInstance());
            session.saveOrUpdate((Object)smimport);
            t.commit();
            long l = smimport.getOperationId();
            return l;
        }
        catch (Exception e) {
            HibernateManager.roolbackTransaction(t);
            throw new Exception();
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public static List<SMTableMetadata> getTables(String user, String template) {
        Session session = HibernateManager.getSessionFactory().openSession();
        ArrayList<SMTableMetadata> tables = new ArrayList<SMTableMetadata>();
        try {
            Query query = session.createQuery("select table.resourceId as tableId, table.name as name, table.description as description, table.template as template, o.completedDate as creationDate, o.operationType as provenance, o.algorithm as algorithm from SMOperation o join o.abstractResource.resource, SMTable table where o.abstractResource.abstractResourceId = table.resourceId and (o.portalLogin like :name or o.portalLogin = null) and table.template like :template");
            query.setParameter("name", (Object)(user != null ? user : "%"));
            query.setParameter("template", (Object)(template != null && !template.equals(TableTemplates.GENERIC) ? template : "%"));
            query.setResultTransformer(Transformers.aliasToBean(SMTableMetadata.class));
            tables.addAll(query.list());
            ArrayList<SMTableMetadata> arrayList = tables;
            return arrayList;
        }
        finally {
            session.close();
        }
    }

    public static SMOperation getOperation(long operationId) throws Exception {
        Session session = HibernateManager.getSessionFactory().openSession();
        try {
            SMOperation sMOperation = (SMOperation)session.get(SMOperation.class, (Serializable)Long.valueOf(operationId));
            return sMOperation;
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public static SMComputations getComputations(String user, String algorithm, String category) throws Exception {
        Session session = HibernateManager.getSessionFactory().openSession();
        try {
            Query query = session.createQuery("select computation from SMComputation  computation where computation.portalLogin like :name and computation.algorithm like :algorithm and computation.category like :category");
            query.setParameter("name", (Object)(user != null ? user : "%"));
            query.setParameter("algorithm", (Object)(algorithm != null ? algorithm : "%"));
            query.setParameter("category", (Object)(category != null ? category : "%"));
            List objects = query.list();
            for (Object object : objects) {
                SMComputation computation = (SMComputation)object;
                Query queryParameters = session.createQuery("select parameter from SMEntry parameter where parameter.computationId = :computationId");
                queryParameters.setParameter("computationId", (Object)computation.getOperationId());
                List parameters = queryParameters.list();
                if (parameters.isEmpty()) continue;
                computation.setParameters(parameters.toArray(new SMEntry[parameters.size()]));
            }
            SMComputation[] computations = objects.toArray(new SMComputation[objects.size()]);
            SMComputations sMComputations = new SMComputations(computations);
            return sMComputations;
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public static long addComputation(SMComputationRequest request) throws Exception {
        Session session = HibernateManager.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            SMComputation smcomputation = new SMComputation();
            smcomputation.setOperationType(SMOperationType.COMPUTED.ordinal());
            smcomputation.setPortalLogin(request.getUser());
            smcomputation.setSubmissionDate(Calendar.getInstance());
            smcomputation.setTitle(request.getTitle());
            smcomputation.setDescription(request.getDescription());
            SMAlgorithm algorithm = request.getConfig().getAlgorithm();
            smcomputation.setAlgorithm(algorithm.getName());
            smcomputation.setCategory(algorithm.getCategory());
            smcomputation.setOperationStatus(SMOperationStatus.PENDING.ordinal());
            session.save((Object)smcomputation);
            SMEntries parameters = request.getConfig().getParameters();
            SMEntry[] sMEntryArray = parameters.getList();
            int n = sMEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                SMEntry parameter = sMEntryArray[n2];
                parameter.setComputationId(smcomputation.getOperationId());
                session.save((Object)parameter);
                ++n2;
            }
            t.commit();
            long l = smcomputation.getOperationId();
            return l;
        }
        catch (Exception e) {
            HibernateManager.roolbackTransaction(t);
            e.printStackTrace();
            throw new Exception();
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public static void addCreatedResource(long operationId, SMResource resource) throws Exception {
        Session session = HibernateManager.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            try {
                SMOperation operation = (SMOperation)session.get(SMOperation.class, (Serializable)Long.valueOf(operationId));
                session.save((Object)resource);
                SMAbstractResource ar = new SMAbstractResource();
                ar.setResource(resource);
                ar.setAbstractResourceId(resource.getResourceId());
                session.save((Object)ar);
                operation.setAbstractResource(ar);
                operation.setOperationStatus(SMOperationStatus.COMPLETED.ordinal());
                operation.setCompletedDate(Calendar.getInstance());
                session.saveOrUpdate((Object)operation);
                t.commit();
            }
            catch (Exception e) {
                logger.debug((Object)"Error persistence ", (Throwable)e);
                HibernateManager.roolbackTransaction(t);
                throw new Exception();
            }
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public static void setOperationStatus(long operationId, SMOperationStatus status) {
        Session session = HibernateManager.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            try {
                SMOperation smoperation = (SMOperation)session.get(SMOperation.class, (Serializable)Long.valueOf(operationId));
                smoperation.setOperationStatus(status.ordinal());
                if (status == SMOperationStatus.FAILED) {
                    smoperation.setCompletedDate(Calendar.getInstance());
                }
                session.saveOrUpdate((Object)smoperation);
                t.commit();
            }
            catch (Exception e) {
                HibernateManager.roolbackTransaction(t);
                HibernateManager.closeSession((org.hibernate.Session)session);
            }
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public static void setComputationalInfrastructure(long operationId, INFRASTRUCTURE infra) {
        Session session = HibernateManager.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            try {
                SMComputation smcomputation = (SMComputation)session.get(SMComputation.class, (Serializable)Long.valueOf(operationId));
                smcomputation.setInfrastructure(infra.toString());
                session.save((Object)smcomputation);
                t.commit();
            }
            catch (Exception e) {
                HibernateManager.roolbackTransaction(t);
                HibernateManager.closeSession((org.hibernate.Session)session);
            }
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public static void removeOperation(long operationId) {
        Session session = HibernateManager.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            try {
                SMOperation smoperation = (SMOperation)session.get(SMOperation.class, (Serializable)Long.valueOf(operationId));
                SMAbstractResource abstractResource = smoperation.getAbstractResource();
                if (abstractResource != null) {
                    SMResource resource = abstractResource.getResource();
                    if (SMResourceType.values()[resource.getResourceType()] == SMResourceType.TABULAR) {
                        try {
                            DataBaseManager.removeTable(resource.getResourceId());
                        }
                        catch (Exception e) {
                            logger.error((Object)"Table no deleted", (Throwable)e);
                        }
                    }
                }
                session.delete((Object)smoperation);
                t.commit();
            }
            catch (Exception e) {
                logger.error((Object)"Computation not removed ", (Throwable)e);
                HibernateManager.roolbackTransaction(t);
                HibernateManager.closeSession((org.hibernate.Session)session);
            }
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public static void removeTable(String tableId) {
        Session session = HibernateManager.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            try {
                Query query = session.createQuery("select o  from SMOperation  o join o.abstractResource.resource, SMTable table where o.abstractResource.abstractResourceId = table.resourceId and table.resourceId = :tableId");
                query.setParameter("tableId", (Object)tableId);
                List objects = query.list();
                SMOperation operation = (SMOperation)objects.get(0);
                SMAbstractResource abstractResource = operation.getAbstractResource();
                if (abstractResource != null) {
                    SMResource resource = abstractResource.getResource();
                    if (SMResourceType.values()[resource.getResourceType()] == SMResourceType.TABULAR) {
                        try {
                            DataBaseManager.removeTable(resource.getResourceId());
                        }
                        catch (Exception e) {
                            logger.error((Object)"Table no deleted", (Throwable)e);
                        }
                    }
                }
                session.delete((Object)operation);
                t.commit();
            }
            catch (Exception e) {
                logger.error((Object)"Computation not removed ", (Throwable)e);
                HibernateManager.roolbackTransaction(t);
                HibernateManager.closeSession((org.hibernate.Session)session);
            }
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public static void checkImport(long importId) {
        Session session = HibernateManager.getSessionFactory().openSession();
        Transaction t = session.beginTransaction();
        try {
            try {
                SMImport smimport = (SMImport)session.get(SMOperation.class, (Serializable)Long.valueOf(importId));
                smimport.setChecked(true);
                session.saveOrUpdate((Object)smimport);
                t.commit();
            }
            catch (Exception e) {
                logger.error((Object)"Computation not removed ", (Throwable)e);
                HibernateManager.roolbackTransaction(t);
                HibernateManager.closeSession((org.hibernate.Session)session);
            }
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }

    public static SMImporters getUncheckedImports(String user) {
        Session session = HibernateManager.getSessionFactory().openSession();
        try {
            Query query = session.createQuery("select importer from SMImport  importer where importer.checked = false and importer.portalLogin like :name ");
            query.setParameter("name", (Object)(user != null ? user : "%"));
            List objects = query.list();
            SMImport[] importers = objects.toArray(new SMImport[objects.size()]);
            SMImporters sMImporters = new SMImporters(importers);
            return sMImporters;
        }
        finally {
            HibernateManager.closeSession((org.hibernate.Session)session);
        }
    }
}

