/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.persistence;

import java.util.List;
import java.util.Map;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.persistence.DataBaseManager;
import org.gcube.data.analysis.statisticalmanager.persistence.HibernateManager;

public class RuntimeResourceManager {
    private static GCUBELog logger = new GCUBELog(RuntimeResourceManager.class);
    private static final String RUNTIME_RESOURCE_DB = "StatisticalManagerDataBase";

    public static void initializeDataBase() throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBERuntimeResourceQuery rtrQuery = (GCUBERuntimeResourceQuery)client.getQuery(GCUBERuntimeResourceQuery.class);
        rtrQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/Name", RUNTIME_RESOURCE_DB)});
        Map scopes = ServiceContext.getContext().getInstance().getScopes();
        List rtrs = null;
        for (Map.Entry scope : scopes.entrySet()) {
            rtrs = client.execute((ISQuery)rtrQuery, (GCUBEScope)scope.getValue());
            if (rtrs != null && !rtrs.isEmpty()) break;
            logger.debug((Object)(" Runtime resource NOT FOUND in scope  " + scope.getValue()));
        }
        if (rtrs == null || rtrs.isEmpty()) {
            throw new StatisticalManagerException("Runtime resource StatisticalManagerDataBase not found");
        }
        GCUBERuntimeResource rtr = (GCUBERuntimeResource)rtrs.get(0);
        if (rtr.getAccessPoints() == null || rtr.getAccessPoints().isEmpty()) {
            throw new StatisticalManagerException("Accesspoint in resource StatisticalManagerDataBase not found");
        }
        for (AccessPoint ap : rtr.getAccessPoints()) {
            if (ap.getEntryname().equals("jdbc")) {
                logger.debug((Object)("URL jdbc  " + ap.getEndpoint()));
                logger.debug((Object)("User jdbc " + ap.getUsername()));
                logger.debug((Object)("Pass jdbc " + ap.getPassword()));
                DataBaseManager.initializeDataSource(ap.getEndpoint(), ap.getUsername(), ap.getPassword());
            }
            if (!ap.getEntryname().equals("hibernate")) continue;
            logger.debug((Object)("URL hibernate  " + ap.getEndpoint()));
            logger.debug((Object)("User hibernate " + ap.getUsername()));
            logger.debug((Object)("Pass hibernate " + ap.getPassword()));
            HibernateManager.buildSessionFactory(ap.getEndpoint(), ap.getUsername(), ap.getPassword());
        }
    }
}

