/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.DataTypeRecognizer;

public class CSVLineProcessorGeneric
implements CSVLineProcessor {
    private boolean stop = true;
    private List<String> sqlTypes = new ArrayList<String>();
    private List<String> colNames = new ArrayList<String>();
    private String separator;
    private static final String colName = "FIELD";

    public CSVLineProcessorGeneric(String separator) {
        this.separator = separator;
    }

    public boolean continueProcessing() {
        return this.stop;
    }

    public void processDataLine(int arg0, List<String> fields) {
        for (String fieldValue : fields) {
            if (fieldValue != null) {
                String[] stringArray = fieldValue.split(this.separator);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    ArrayList<String> values = new ArrayList<String>();
                    values.add(value);
                    String className = DataTypeRecognizer.guessType(values);
                    String sqlType = null;
                    if (String.class.getName().equals(className)) {
                        sqlType = "varchar";
                    }
                    if (Boolean.class.getName().equals(className)) {
                        sqlType = "boolean";
                    }
                    if (BigDecimal.class.getName().equals(className)) {
                        sqlType = "double precision";
                    }
                    this.sqlTypes.add(sqlType);
                    ++n2;
                }
                continue;
            }
            this.sqlTypes.add("varchar");
        }
        this.stop = false;
    }

    public void processHeaderLine(int arg0, List<String> fields) {
        boolean index = true;
        for (String fieldName : fields) {
            String[] values;
            String[] stringArray = values = fieldName.split(this.separator);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                this.colNames.add(value);
                ++n2;
            }
        }
    }

    public List<String> getColsName() {
        return this.colNames;
    }

    public List<String> getSqlType() {
        return this.sqlTypes;
    }
}

