package org.gcube.data.analysis.statisticalmanager.dataspace.importer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;

import org.apache.commons.io.IOUtils;
import org.gcube.common.core.utils.logging.GCUBELog;

import com.thoughtworks.xstream.XStream;

public class FileManager {
		
	private static GCUBELog logger = new GCUBELog(FileManager.class);
	
	private static final String TMP_FOLDER = "tmp/";
	private static final String PERSISTENCE_FOLDER = "persistence/";
	
	private String tmpFolder;
	private String persistenceFolder;
	
	private String initializeFolder(String persistencePath) {
		
		File f=new File(persistencePath);
		if(!f.exists()){
			logger.debug("Creating persistence folder "+persistencePath);
			f.mkdirs();
			try {
				Process proc=Runtime.getRuntime().exec("chmod -R 777 "+persistencePath);
				try{
					proc.waitFor();
				}catch(InterruptedException e){
					int exitValue=proc.exitValue();
					logger.debug("Permission execution exit value = "+exitValue);
				}
			} catch (IOException e) {
				logger.warn("Unexpected Exception", e);
			}
		}
		return persistencePath;
	}
	
	public FileManager(String persistenceFolder){	
		this.tmpFolder = persistenceFolder +
				File.separator + TMP_FOLDER;
		initializeFolder(this.tmpFolder);
		
		this.persistenceFolder = persistenceFolder +
				File.separator + PERSISTENCE_FOLDER;
		initializeFolder(this.persistenceFolder);
	}
	
	public  String serializeObject(Object object, String fileExtension) 
	throws SMFileManagerException {
		
		String fileName = UUID.randomUUID().toString() + fileExtension; 
		String filePath =  tmpFolder + fileName; 
		
		FileOutputStream fos = null;
		
		try{
			fos = new FileOutputStream (filePath);
			XStream xstream = new XStream();
			xstream.toXML(object, fos);
		}
		catch (Exception e){
			throw new SMFileManagerException(e.getMessage());
		} finally {
			IOUtils.closeQuietly(fos);
		}
		
		return filePath;	
	}
	
}
