/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.experimentspace.computation;

import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.data.analysis.statisticalmanager.SMOperationStatus;
import org.gcube.data.analysis.statisticalmanager.SMResourceType;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.dataspace.importer.FileManager;
import org.gcube.data.analysis.statisticalmanager.experimentspace.AlgorithmCategory;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactory;
import org.gcube.data.analysis.statisticalmanager.experimentspace.computation.SMComputationalAgentInitializationException;
import org.gcube.data.analysis.statisticalmanager.experimentspace.computation.SMParametersSettingException;
import org.gcube.data.analysis.statisticalmanager.experimentspace.computation.SMResourcesNotAvailableException;
import org.gcube.data.analysis.statisticalmanager.persistence.DataBaseManager;
import org.gcube.data.analysis.statisticalmanager.persistence.SMPersistenceManager;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationConfig;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.processing.factories.ClusterersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.EvaluatorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ModelersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationalAgentClass;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMEntry;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMFile;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMObject;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMResource;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTable;
import org.globus.wsrf.ResourceProperty;

public class ComputationResource
extends GCUBEWSResource {
    private static final String NAME_RP_NAME = "computation";
    private volatile String userLogin;
    private volatile String scope;
    private static FileManager fileManager = new FileManager(ServiceContext.getContext().getPersistenceRoot().getAbsolutePath());
    private static ConcurrentHashMap<String, ComputationalAgent> runningCAgents = new ConcurrentHashMap();

    private String getConfigPath() {
        return ServiceContext.getContext().getProperty("configDir", new boolean[0]) + "/cfg/";
    }

    public void cleanResourcesComputational(INFRASTRUCTURE compInf, long computationId) {
        switch (compInf) {
            case LOCAL: {
                this.logger.debug((Object)"---------- Clean up local resources");
                ComputationFactory.getFactoryResource().cleanLocalResourcesComputational(String.valueOf(computationId));
                break;
            }
            case D4SCIENCE: {
                this.logger.debug((Object)"--------- Clen up D4Science resources");
                ComputationFactory.getFactoryResource().cleanD4ScienceComputation();
            }
        }
    }

    private synchronized void addComputationalAgent(String key, ComputationalAgent agent) {
        runningCAgents.put(key, agent);
        ResourceProperty property = this.getResourcePropertySet().get(NAME_RP_NAME);
        property.add((Object)key);
    }

    private synchronized void removeComputationalAgent(String key) {
        runningCAgents.remove(key);
        ResourceProperty property = this.getResourcePropertySet().get(NAME_RP_NAME);
        property.clear();
        for (Map.Entry<String, ComputationalAgent> entry : runningCAgents.entrySet()) {
            property.add((Object)entry.getKey());
        }
    }

    private void setComputationOutput(long computationId, ComputationalAgent agent) throws Exception {
        StatisticalType output = agent.getOutput();
        this.logger.debug((Object)("ComputationalAgent getOutput() : " + agent.getOutput().getClass().getName()));
        if (output instanceof PrimitiveType) {
            IClient client = new StorageClient(ServiceContext.class.getPackage().getName(), "StatisticalManager", this.userLogin, AccessType.SHARED, GCUBEScope.getScope((String)this.scope)).getClient();
            String rootDir = "/statisticalManager/";
            if (((PrimitiveType)output).getType() == PrimitiveTypes.FILE) {
                this.logger.debug((Object)"Output is a file");
                this.logger.debug((Object)("Output file path" + ((File)((PrimitiveType)output).getContent()).getAbsolutePath()));
                File outputFile = (File)((PrimitiveType)output).getContent();
                String rfileName = rootDir + outputFile.getName();
                client.put(true).LFile(outputFile.getAbsolutePath()).RFile(rfileName);
                String url = client.getUrl().RFile(rfileName);
                this.logger.debug((Object)("URL :" + url));
                SMFile file = new SMFile("mimeType", url);
                file.setResourceType(SMResourceType.FILE.ordinal());
                file.setResourceId(UUID.randomUUID().toString());
                file.setDescription(output.getDescription());
                file.setName(outputFile.getName());
                SMPersistenceManager.addCreatedResource(computationId, (SMResource)file);
                return;
            }
            if (((PrimitiveType)output).getType() == PrimitiveTypes.MAP) {
                this.logger.debug((Object)" ---------------- Map output --------------");
                Map object = (Map)((PrimitiveType)output).getContent();
                this.logger.debug((Object)("Serialize map object :" + object));
                String filePath = fileManager.serializeObject(object, ".smm");
                this.logger.debug((Object)("Object serialized in file " + filePath));
                File file = new File(filePath);
                String rfileName = rootDir + file.getName();
                client.put(true).LFile(filePath).RFile(rfileName);
                this.logger.debug((Object)("File put with name " + rfileName));
                String url = client.getUrl().RFile(rfileName);
                this.logger.debug((Object)("URL :" + url));
                if (url == null) {
                    throw new Exception();
                }
                SMObject resource = new SMObject(url);
                resource.setResourceType(SMResourceType.OBJECT.ordinal());
                resource.setResourceId(UUID.randomUUID().toString());
                resource.setName(PrimitiveTypes.MAP.toString());
                resource.setDescription(output.getDescription());
                resource.setResourceId(UUID.randomUUID().toString());
                SMPersistenceManager.addCreatedResource(computationId, (SMResource)resource);
                file.delete();
                return;
            }
            if (((PrimitiveType)output).getType() == PrimitiveTypes.IMAGES) {
                this.logger.debug((Object)" ---------------- IMAGES output --------------");
                Map map = (Map)((PrimitiveType)output).getContent();
                this.logger.debug((Object)" ------------------ Cast to map of images ---------");
                String dirName = "/" + UUID.randomUUID().toString();
                this.logger.debug((Object)(" ------------------- DIR CREATED : " + dirName));
                for (Map.Entry entry : map.entrySet()) {
                    this.logger.debug((Object)("Image " + (String)entry.getKey() + " found"));
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    boolean result = ImageIO.write((RenderedImage)ImageTools.toBufferedImage((Image)((Image)entry.getValue())), "png", os);
                    this.logger.debug((Object)("Image stored " + result));
                    String clientResult = client.put(true).LFile((InputStream)new ByteArrayInputStream(os.toByteArray())).RFile(dirName + "/" + (String)entry.getKey());
                    this.logger.debug((Object)("ClientResult" + clientResult));
                    if (clientResult != null) continue;
                    throw new Exception();
                }
                SMObject resource = new SMObject(dirName);
                resource.setResourceType(SMResourceType.OBJECT.ordinal());
                resource.setResourceId(UUID.randomUUID().toString());
                resource.setName(PrimitiveTypes.IMAGES.toString());
                resource.setDescription(output.getDescription());
                resource.setResourceId(UUID.randomUUID().toString());
                SMPersistenceManager.addCreatedResource(computationId, (SMResource)resource);
            }
        }
        if (output instanceof OutputTable) {
            this.logger.debug((Object)"Add tabular data");
            SMTable table = new SMTable(((TableTemplates)((OutputTable)output).getTemplateNames().get(0)).toString());
            table.setResourceType(SMResourceType.TABULAR.ordinal());
            table.setResourceId(((OutputTable)output).getTableName());
            table.setDescription(output.getDescription());
            table.setName(output.getName());
            SMPersistenceManager.addCreatedResource(computationId, (SMResource)table);
            return;
        }
    }

    public void initialise(Object ... args) throws Exception {
        this.logger.debug((Object)"------ initialize Service Resource");
        this.userLogin = (String)args[0];
        this.scope = (String)args[1];
    }

    protected String[] getPropertyNames() {
        return new String[]{NAME_RP_NAME};
    }

    public static FileManager getFileManager() {
        return fileManager;
    }

    public ConcurrentHashMap<String, ComputationalAgent> getComputationalAgents() {
        return runningCAgents;
    }

    private AlgorithmConfiguration setUserParameters(AlgorithmConfiguration algoConfig, SMComputationConfig requestConfig) {
        for (SMEntry parameter : requestConfig.getParameters().getList()) {
            this.logger.debug((Object)("Set Parameter user key " + parameter.getKey() + " value " + parameter.getValue()));
            String value = parameter.getValue();
            algoConfig.setParam(parameter.getKey(), value);
        }
        return algoConfig;
    }

    public List<StatisticalType> getListParameters(SMAlgorithm algorithm) throws Exception {
        switch (AlgorithmCategory.valueOf(algorithm.getCategory())) {
            case DISTRIBUTIONS: {
                return GeneratorsFactory.getAlgorithmParameters((String)this.getConfigPath(), (String)algorithm.getName());
            }
            case EVALUATORS: {
                return EvaluatorsFactory.getEvaluatorParameters((String)this.getConfigPath(), (String)algorithm.getName());
            }
            case MODELS: {
                return ModelersFactory.getModelParameters((String)this.getConfigPath(), (String)algorithm.getName());
            }
            case TRANSDUCERS: {
                return TransducerersFactory.getTransducerParameters((String)this.getConfigPath(), (String)algorithm.getName());
            }
            case CLUSTERERS: {
                return ClusterersFactory.getClustererParameters((String)this.getConfigPath(), (String)algorithm.getName());
            }
        }
        throw new Exception();
    }

    private void setServiceParameters(SMComputationConfig computationConfig, AlgorithmConfiguration algoConfig, List<StatisticalType> parameters) throws SMParametersSettingException {
        this.logger.debug((Object)("Parameter retrieved " + parameters.size()));
        for (StatisticalType parameter : parameters) {
            this.logger.debug((Object)("Parameter retrieved " + parameter.getClass()));
            if (parameter instanceof DatabaseType) {
                switch (((DatabaseType)parameter).getDatabaseParameter()) {
                    case DATABASEURL: {
                        algoConfig.setParam(parameter.getName(), DataBaseManager.getUrlDB());
                        break;
                    }
                    case DATABASEPASSWORD: {
                        algoConfig.setParam(parameter.getName(), DataBaseManager.getPassword());
                        break;
                    }
                    case DATABASEUSERNAME: {
                        algoConfig.setParam(parameter.getName(), DataBaseManager.getUsername());
                        break;
                    }
                    case DATABASEDRIVER: {
                        algoConfig.setParam(parameter.getName(), DataBaseManager.getDriver());
                        break;
                    }
                }
            }
            if (parameter instanceof ServiceType) {
                if (((ServiceType)parameter).getServiceParameter() == ServiceParameters.RANDOMSTRING) {
                    String id = "ID_" + UUID.randomUUID().toString().replace("-", "_");
                    if (parameter.getDefaultValue() != null) {
                        id = parameter.getDefaultValue() + id;
                    }
                    this.logger.debug((Object)("Param service name:" + parameter.getName() + " value :" + id.toLowerCase()));
                    algoConfig.setParam(parameter.getName(), id.toLowerCase());
                }
                if (((ServiceType)parameter).getServiceParameter() == ServiceParameters.USERNAME) {
                    this.logger.debug((Object)("Param service name:" + parameter.getName() + " value :" + ((GCUBEWSResourceKey)this.getID()).getValue()));
                    algoConfig.setParam(parameter.getName(), ((GCUBEWSResourceKey)this.getID()).getValue());
                }
            }
            if (!(parameter instanceof PrimitiveType) || ((PrimitiveType)parameter).getType() != PrimitiveTypes.CONSTANT) continue;
            algoConfig.setParam(parameter.getName(), parameter.getDefaultValue());
            this.logger.debug((Object)("Param primitive name constant : " + parameter.getName() + " value : " + parameter.getDefaultValue()));
        }
    }

    public void executeComputation(SMComputationConfig computationConfig, long computationId) throws SMResourcesNotAvailableException {
        AlgorithmConfiguration algoConfig = new AlgorithmConfiguration();
        String algorithm = null;
        try {
            this.logger.debug((Object)" ------------- Computation request: ");
            String configPath = this.getConfigPath();
            algorithm = computationConfig.getAlgorithm().getName();
            this.logger.debug((Object)(" ------------- Algorithm request" + algorithm));
            algoConfig.setConfigPath(configPath);
            algoConfig.setAgent(algorithm);
            algoConfig.setModel(algorithm);
            algoConfig.setPersistencePath(configPath);
            this.logger.debug((Object)"Set user parameters init");
            this.setUserParameters(algoConfig, computationConfig);
            this.logger.debug((Object)"Set service paramter init");
            List<StatisticalType> parameters = this.getListParameters(computationConfig.getAlgorithm());
            this.setServiceParameters(computationConfig, algoConfig, parameters);
        }
        catch (Exception e) {
            this.logger.error((Object)"Set service parameter error in execute computation :", (Throwable)e);
            try {
                SMPersistenceManager.setOperationStatus(computationId, SMOperationStatus.FAILED);
            }
            catch (Exception e1) {
                this.logger.error((Object)"Set status failed error in excute computation set parameters :", (Throwable)e1);
            }
            return;
        }
        try {
            this.logger.debug((Object)"Init computation");
            this.initComputation(computationConfig, algorithm, algoConfig, computationId);
        }
        catch (SMComputationalAgentInitializationException e) {
            this.logger.error((Object)"Init computation failed", (Throwable)e);
            try {
                SMPersistenceManager.setOperationStatus(computationId, SMOperationStatus.FAILED);
            }
            catch (Exception e1) {
                this.logger.error((Object)"Set status failed error in init computation :", (Throwable)e1);
            }
        }
    }

    private void startComputation(final long computationId, final INFRASTRUCTURE infra, final ComputationalAgent agent) throws SMComputationalAgentInitializationException {
        this.addComputationalAgent(String.valueOf(computationId), agent);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SMPersistenceManager.setOperationStatus(computationId, SMOperationStatus.RUNNING);
                    agent.init();
                    agent.compute();
                    ComputationResource.this.setComputationOutput(computationId, agent);
                }
                catch (Exception e) {
                    ComputationResource.this.logger.error((Object)"Compute action failed", (Throwable)e);
                    try {
                        SMPersistenceManager.setOperationStatus(computationId, SMOperationStatus.FAILED);
                    }
                    catch (Exception e1) {
                        ComputationResource.this.logger.error((Object)("Error save status FAILED computation " + computationId), (Throwable)e1);
                    }
                }
                finally {
                    ComputationResource.this.cleanResourcesComputational(infra, computationId);
                    ComputationResource.this.removeComputationalAgent(String.valueOf(computationId));
                }
            }
        }.start();
    }

    private List<? extends ComputationalAgent> getComputationalAgentsAvailable(SMComputationConfig computationConfig, AlgorithmConfiguration algoConfig) throws SMComputationalAgentInitializationException {
        ComputationalAgentClass cac = ComputationalAgentClass.fromString((String)computationConfig.getAlgorithm().getCategory());
        try {
            switch (AlgorithmCategory.valueOf(cac.getValue())) {
                case DISTRIBUTIONS: {
                    return GeneratorsFactory.getGenerators((AlgorithmConfiguration)algoConfig);
                }
                case EVALUATORS: {
                    return EvaluatorsFactory.getEvaluators((AlgorithmConfiguration)algoConfig);
                }
                case CLUSTERERS: {
                    return ClusterersFactory.getClusterers((AlgorithmConfiguration)algoConfig);
                }
                case MODELS: {
                    return ModelersFactory.getModelers((AlgorithmConfiguration)algoConfig);
                }
                case TRANSDUCERS: {
                    return TransducerersFactory.getTransducerers((AlgorithmConfiguration)algoConfig);
                }
            }
            this.logger.error((Object)"Computational agent category not found ");
            throw new Exception();
        }
        catch (Exception e) {
            this.logger.error((Object)"Computational agent list not found", (Throwable)e);
            throw new SMComputationalAgentInitializationException("Algorithm requested not found" + cac.getValue());
        }
    }

    private void initComputation(SMComputationConfig computationConfig, String algorithm, AlgorithmConfiguration algoConfig, long computationId) throws SMComputationalAgentInitializationException, SMResourcesNotAvailableException {
        this.logger.debug((Object)" GET ComputationalAgent List ...");
        algoConfig.setNumberOfResources(Integer.valueOf(1));
        List<? extends ComputationalAgent> agents = this.getComputationalAgentsAvailable(computationConfig, algoConfig);
        this.logger.debug((Object)(" FOUND Generetors List with size ..." + agents));
        for (ComputationalAgent computationalAgent : agents) {
            this.logger.debug((Object)("INFRASTRACTURE for ComputationalAgent found : " + computationalAgent.getInfrastructure().toString()));
            switch (computationalAgent.getInfrastructure()) {
                case D4SCIENCE: {
                    this.logger.debug((Object)"Start D4Science computation");
                    if (!ComputationFactory.getFactoryResource().setD4ScienceComputation()) {
                        this.logger.debug((Object)"D4Science resource not available");
                        break;
                    }
                    try {
                        SMPersistenceManager.setComputationalInfrastructure(computationId, INFRASTRUCTURE.D4SCIENCE);
                        String infra = (String)GHNContext.getContext().getProperty("infrastructure", new boolean[]{true});
                        algoConfig.setGcubeScope("/" + infra);
                        this.logger.debug((Object)"Retrieve ComputationalAgent parameters .... ");
                        List parameters = computationalAgent.getInputParameters();
                        this.setServiceParameters(computationConfig, algoConfig, parameters);
                        computationalAgent.setConfiguration(algoConfig);
                        this.startComputation(computationId, INFRASTRUCTURE.D4SCIENCE, computationalAgent);
                        this.logger.debug((Object)"Computation started in D4Science ... ");
                        return;
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Start computation failed", (Throwable)e);
                        this.cleanResourcesComputational(INFRASTRUCTURE.D4SCIENCE, computationId);
                        throw new SMComputationalAgentInitializationException("ComputationalAgent initialization failed " + e.getMessage());
                    }
                }
                case LOCAL: {
                    int resources = ComputationFactory.getFactoryResource().setLocalResourcesAvailable(String.valueOf(computationId), computationConfig.getAlgorithm());
                    if (resources <= 0) {
                        throw new SMResourcesNotAvailableException("Local Resources not available");
                    }
                    try {
                        this.logger.debug((Object)"Computation started in LOCAL ...");
                        SMPersistenceManager.setComputationalInfrastructure(computationId, INFRASTRUCTURE.LOCAL);
                        this.logger.debug((Object)"Set number of resources ");
                        algoConfig.setNumberOfResources(Integer.valueOf(resources));
                        computationalAgent.setConfiguration(algoConfig);
                        this.startComputation(computationId, INFRASTRUCTURE.LOCAL, computationalAgent);
                        return;
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Start computation failed", (Throwable)e);
                        this.cleanResourcesComputational(INFRASTRUCTURE.LOCAL, computationId);
                        throw new SMComputationalAgentInitializationException("ComputationalAgent initialization failed " + e.getMessage());
                    }
                }
            }
        }
        throw new SMComputationalAgentInitializationException("Computation initialization failed");
    }
}

