package org.gcube.data.analysis.statisticalmanager.dataspace.exporter;

import static org.gcube.data.analysis.statisticalmanager.persistence.DataBaseManager.closeConn;

import java.io.File;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;


import org.gcube.data.analysis.statisticalmanager.persistence.DataBaseManager;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;

public class CSVExporter {

	private File file;
	private String tableId;
	
	public CSVExporter(String tableId, File file) {
		this.file = file;
		this.tableId = tableId;
	}
	
	public long exporterToFile() throws Exception {
		
		Connection conn = null;
		try {
			conn = DriverManager.getConnection(DataBaseManager.getUrlDB(),
					DataBaseManager.getUsername(), DataBaseManager.getPassword());
			CopyManager copyManager = new CopyManager((BaseConnection) conn);
			long result = copyManager.copyOut(String.format("COPY %s TO STDOUT CSV HEADER",
					tableId), new FileOutputStream(file));
			return result;			
		} finally {
			closeConn(conn);
		}
		
	}
	
}
