package org.gcube.data.analysis.statisticalmanager.experimentspace.computation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

import java.awt.Image;




import javax.imageio.ImageIO;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.data.analysis.statisticalmanager.SMOperationStatus;
import org.gcube.data.analysis.statisticalmanager.SMResourceType;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;

import org.gcube.data.analysis.statisticalmanager.dataspace.importer.FileManager;
import org.gcube.data.analysis.statisticalmanager.experimentspace.AlgorithmCategory;
import org.gcube.data.analysis.statisticalmanager.experimentspace.ComputationFactory;


import org.gcube.data.analysis.statisticalmanager.persistence.DataBaseManager;
import org.gcube.data.analysis.statisticalmanager.persistence.SMPersistenceManager;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationConfig;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.processing.factories.ClusterersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.EvaluatorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ModelersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationalAgentClass;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMEntry;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMFile;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMObject;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTable;
import org.globus.wsrf.ResourceProperty;



public class ComputationResource extends GCUBEWSResource{
			
	private static final String NAME_RP_NAME = "computation";
	private volatile String userLogin;
	private volatile String scope;

	private static FileManager 
	fileManager = new FileManager(ServiceContext.getContext().
			getPersistenceRoot().getAbsolutePath());
	
	private static ConcurrentHashMap<String,ComputationalAgent> 
	runningCAgents = new ConcurrentHashMap<String,ComputationalAgent>();
    	
	private String getConfigPath() {
	    	return ServiceContext.getContext().getProperty("configDir") + "/cfg/";
	}
	
	public void cleanResourcesComputational(final INFRASTRUCTURE compInf, final long computationId) {
		
		switch (compInf) {
		case LOCAL:
			logger.debug("---------- Clean up local resources");
			ComputationFactory.getFactoryResource().
			cleanLocalResourcesComputational(String.valueOf(computationId));
			break;
		case D4SCIENCE:
			logger.debug("--------- Clen up D4Science resources");
			ComputationFactory.getFactoryResource().
			cleanD4ScienceComputation();
		default:
			break;
		}
		
	}
	
	private synchronized void addComputationalAgent(String key, ComputationalAgent agent) {
	
		runningCAgents.put(key, agent);
		
		ResourceProperty property = getResourcePropertySet().get(NAME_RP_NAME);
		property.add(key);
	}
	
	private synchronized void removeComputationalAgent(String key) {
		
		runningCAgents.remove(key);

		ResourceProperty property = getResourcePropertySet().get(NAME_RP_NAME);
		property.clear();
		
		for ( Entry<String, ComputationalAgent> entry : runningCAgents.entrySet()) {
			property.add(entry.getKey());
		}
		
	}
	 
    private void setComputationOutput(long computationId, 
    		ComputationalAgent agent) throws Exception {
    	   	
    	StatisticalType output = agent.getOutput();   	
    	logger.debug("ComputationalAgent getOutput() : " +  agent.getOutput().getClass().getName());
    	if (output instanceof PrimitiveType) {
    				
			IClient client = new StorageClient( ServiceContext.class.getPackage().getName(),
					"StatisticalManager", userLogin , AccessType.SHARED,
					GCUBEScope.getScope(scope)).getClient();
    		
			String rootDir = "/statisticalManager/";
			
    		if (((PrimitiveType) output).getType() == PrimitiveTypes.FILE) {
    			
    			logger.debug("Output is a file");
    			logger.debug("Output file path" + ((File)((PrimitiveType) output).getContent()).getAbsolutePath());

    			File outputFile = (File)((PrimitiveType) output).getContent();
    			
    			String rfileName = rootDir + outputFile.getName();
    			client.put(true).LFile(outputFile.getAbsolutePath()).RFile(rfileName);
    			String url = client.getUrl().RFile(rfileName);
    			logger.debug("URL :" + url);
    			
    			SMFile file = new SMFile("mimeType", url);
    			file.setResourceType(SMResourceType.FILE.ordinal());
    			file.setResourceId(UUID.randomUUID().toString());
    			file.setDescription(output.getDescription());
    			file.setName(outputFile.getName());
				
    			SMPersistenceManager.addCreatedResource(computationId, file);
    			
    			return;
    		}
    		
    		if (((PrimitiveType) output).getType() == PrimitiveTypes.MAP) {
    			
    			logger.debug(" ---------------- Map output --------------");
    			
				Map<String,String> object = (Map<String,String>)((PrimitiveType) output).getContent();
				
    			logger.debug("Serialize map object :" + object);
    			String filePath = fileManager.serializeObject(object, ".smm");
    			logger.debug("Object serialized in file " + filePath);
    			    			
    			File file = new File(filePath);
    			
    			String rfileName = rootDir + file.getName();
				client.put(true).LFile(filePath).RFile(rfileName);
				logger.debug("File put with name " + rfileName);
				
				String url = client.getUrl().RFile(rfileName);
				logger.debug("URL :" + url);
				if (url == null)
					throw new Exception();
				
				SMObject resource = new SMObject(url);
				resource.setResourceType(SMResourceType.OBJECT.ordinal());
				resource.setResourceId(UUID.randomUUID().toString());
				resource.setName(PrimitiveTypes.MAP.toString());
				resource.setDescription(output.getDescription());				
				resource.setResourceId(UUID.randomUUID().toString());

				SMPersistenceManager.addCreatedResource(computationId, resource);
    			file.delete();
    			
    			return;
    		}
    		
    		if (((PrimitiveType) output).getType() == PrimitiveTypes.IMAGES) {
    			
    			logger.debug(" ---------------- IMAGES output --------------");
    			
				Map<String,Image> map = (Map<String,Image>)((PrimitiveType) output).getContent();
				logger.debug(" ------------------ Cast to map of images ---------");
				String dirName = "/" + UUID.randomUUID().toString();
				logger.debug(" ------------------- DIR CREATED : " + dirName);
				for(Entry<String, Image> entry : map.entrySet()) {	
					logger.debug("Image " + entry.getKey() + " found");
					ByteArrayOutputStream os = new ByteArrayOutputStream();
					boolean result = ImageIO.write(ImageTools.toBufferedImage(entry.getValue()),"png",os);
					logger.debug("Image stored " + result);
					
					String clientResult = client.put(true).LFile(new ByteArrayInputStream(os.toByteArray())).RFile(dirName + "/" + entry.getKey());
					logger.debug("ClientResult" +clientResult);
					if (clientResult == null) {
						throw new Exception();
					}
				}    		
				
				SMObject resource = new SMObject(dirName);
				resource.setResourceType(SMResourceType.OBJECT.ordinal());
				resource.setResourceId(UUID.randomUUID().toString());
				resource.setName(PrimitiveTypes.IMAGES.toString());
				resource.setDescription(output.getDescription());				
				resource.setResourceId(UUID.randomUUID().toString());
				
				SMPersistenceManager.addCreatedResource(computationId, resource);
    		}
    	}
		
    	if (output instanceof OutputTable) {	
    		
    		logger.debug("Add tabular data");

    		SMTable table = new SMTable(((OutputTable) output).getTemplateNames().get(0).toString());
    		table.setResourceType(SMResourceType.TABULAR.ordinal());
    		table.setResourceId(((OutputTable) output).getTableName());
    		table.setDescription(output.getDescription());
    		table.setName(output.getName());
			
    		SMPersistenceManager.addCreatedResource(computationId, table);
    		
    		return;
    	}

    }
    
     /**{@inheritDoc}*/
    @Override
	public void initialise(Object... args) throws Exception {
    	
    	logger.debug("------ initialize Service Resource");
    	userLogin = (String)args[0];
    	scope = (String)args[1];
    	
    	
    }
    
    /** {@inheritDoc} */
    @Override
	protected String[] getPropertyNames() {return new String[]{NAME_RP_NAME};}
    
    public static FileManager getFileManager() {return fileManager;}
   
    public ConcurrentHashMap<String,ComputationalAgent> getComputationalAgents() {return runningCAgents;}
           
    private AlgorithmConfiguration setUserParameters(AlgorithmConfiguration algoConfig,
    		SMComputationConfig requestConfig) {
				
		// Set user algorithms parameters
 		for( SMEntry parameter : requestConfig.getParameters().getList()) {	
			logger.debug("Set Parameter user key " + parameter.getKey()  + " value " + parameter.getValue());
			String value = parameter.getValue();			
			algoConfig.setParam(parameter.getKey(),value);
		}
		return algoConfig;
	}
    
    public List<StatisticalType> getListParameters(SMAlgorithm algorithm) throws Exception {
	   	
    	switch(AlgorithmCategory.valueOf(algorithm.getCategory())){
    	case DISTRIBUTIONS:
    		return GeneratorsFactory.getAlgorithmParameters(getConfigPath(), 
    				algorithm.getName());

    	case EVALUATORS:
    		return EvaluatorsFactory.getEvaluatorParameters(getConfigPath(), 
    				algorithm.getName());

    	case MODELS:
    		return ModelersFactory.getModelParameters(getConfigPath(),
    				algorithm.getName());
    	
    	case TRANSDUCERS:
    		return TransducerersFactory.getTransducerParameters(getConfigPath(),
    				algorithm.getName());
    		
    	case CLUSTERERS:
    		return ClusterersFactory.getClustererParameters(getConfigPath(),
    				algorithm.getName());
    	default:
    		throw new Exception();
    	}

    }
    
    private void setServiceParameters(SMComputationConfig computationConfig,
    		AlgorithmConfiguration algoConfig, List<StatisticalType> parameters) throws SMParametersSettingException {
    	
    	
		logger.debug("Parameter retrieved " + parameters.size());
    	for (StatisticalType parameter : parameters) {
    		
    		logger.debug("Parameter retrieved " + parameter.getClass());
    		if (parameter instanceof DatabaseType) {

    			switch (((DatabaseType) parameter).getDatabaseParameter()) {
    			case DATABASEURL:				
    				algoConfig.setParam(parameter.getName(), DataBaseManager.getUrlDB());
    				break;	
    			case DATABASEPASSWORD:
    				algoConfig.setParam(parameter.getName(), DataBaseManager.getPassword());
    				break;
    			case DATABASEUSERNAME:
    				algoConfig.setParam(parameter.getName(), DataBaseManager.getUsername());
    				break;
    			case DATABASEDRIVER:
    				algoConfig.setParam(parameter.getName(), DataBaseManager.getDriver());
    				break;
    			default:
    				break;
    			}
    		}
    		
    		if (parameter instanceof ServiceType) {
    			if(((ServiceType) parameter).getServiceParameter() == ServiceParameters.RANDOMSTRING) {
    				String id = "ID_" + UUID.randomUUID().toString().replace("-", "_");
    				if(parameter.getDefaultValue() != null) {
    					id = parameter.getDefaultValue() + id;
    				}
    				logger.debug("Param service name:" + parameter.getName() +  " value :" + id.toLowerCase());
    				algoConfig.setParam(parameter.getName(), id.toLowerCase());
    				
    			}

    			if (((ServiceType) parameter).getServiceParameter() == ServiceParameters.USERNAME) {
    				logger.debug("Param service name:" + parameter.getName() +  " value :" + getID().getValue());
    				algoConfig.setParam(parameter.getName(), getID().getValue());
    			}

    		}
    			
    		if (parameter instanceof PrimitiveType) {
    			if (((PrimitiveType)parameter).getType() == PrimitiveTypes.CONSTANT) {
    				algoConfig.setParam(parameter.getName(), parameter.getDefaultValue());
    				logger.debug("Param primitive name constant : " + parameter.getName() +
    						" value : " + parameter.getDefaultValue());
    			}	
    		}
    	}
    }
    
    public void executeComputation(SMComputationConfig computationConfig,
    		final long computationId) throws SMResourcesNotAvailableException {

    	AlgorithmConfiguration algoConfig = new AlgorithmConfiguration();
    	String algorithm = null;
    	try {
    		logger.debug(" ------------- Computation request: ");
        	String configPath = getConfigPath();
        	algorithm =  computationConfig.getAlgorithm().getName();
        	logger.debug(" ------------- Algorithm request" + algorithm);
        	        	
        	algoConfig.setConfigPath(configPath);
        	algoConfig.setAgent(algorithm);
        	algoConfig.setModel(algorithm);
        	algoConfig.setPersistencePath(configPath);

    		logger.debug("Set user parameters init");
        	setUserParameters(algoConfig,computationConfig);
        	
        	logger.debug("Set service paramter init");
    		List<StatisticalType> parameters = getListParameters(computationConfig.getAlgorithm());		
			setServiceParameters(computationConfig, algoConfig, parameters);
		} catch (Exception e) {
			logger.error("Set service parameter error in execute computation :",e);
			try {
				SMPersistenceManager.setOperationStatus(
						computationId, SMOperationStatus.FAILED);
			} catch (Exception e1) {
				logger.error("Set status failed error in excute computation" +
						" set parameters :",e1);
			}
			return;
		}
		
    	try {
    		logger.debug("Init computation");
			initComputation(computationConfig, algorithm, algoConfig, computationId);
		} catch (SMComputationalAgentInitializationException e) {
			logger.error("Init computation failed", e);
			try {
				SMPersistenceManager.setOperationStatus(
						computationId, SMOperationStatus.FAILED);
			} catch (Exception e1) {
				logger.error("Set status failed error in init computation :",e1);
			}
		} 
    }

	private void startComputation(final long computationId, final INFRASTRUCTURE infra,
			final ComputationalAgent agent) throws SMComputationalAgentInitializationException {
		
		
		addComputationalAgent(String.valueOf(computationId), agent);
		
		new Thread() {
			@Override
			public void run() {
				try {
					
					SMPersistenceManager.setOperationStatus(computationId,
							SMOperationStatus.RUNNING);
					
					agent.init();
					agent.compute();
					
					setComputationOutput(computationId, agent); 
					
				} catch (Exception e) {
					logger.error("Compute action failed", e);
					try {
						SMPersistenceManager.setOperationStatus(computationId,
								SMOperationStatus.FAILED);
						
					} catch (Exception e1) {
						logger.error("Error save status FAILED computation " + computationId,e1);
					}

				} finally {
					cleanResourcesComputational(infra, computationId);
					removeComputationalAgent(String.valueOf(computationId));
				}
			}
		}.start();
	}
    
	private List<? extends ComputationalAgent> getComputationalAgentsAvailable(SMComputationConfig computationConfig,
			AlgorithmConfiguration algoConfig) throws SMComputationalAgentInitializationException {
		
    	ComputationalAgentClass cac = ComputationalAgentClass.fromString(computationConfig.getAlgorithm().getCategory());
    	try {
    		switch (AlgorithmCategory.valueOf(cac.getValue())) {
    		case DISTRIBUTIONS: 
    			return GeneratorsFactory.getGenerators(algoConfig);
    		case EVALUATORS:
    			return EvaluatorsFactory.getEvaluators(algoConfig);
    		case CLUSTERERS:
    			return ClusterersFactory.getClusterers(algoConfig);
    		case MODELS:
    			return ModelersFactory.getModelers(algoConfig);
    		case TRANSDUCERS:
    			return TransducerersFactory.getTransducerers(algoConfig);
    		default:
    			logger.error("Computational agent category not found ");
    			throw new Exception();
    		}
    	} catch (Exception e) {
    		logger.error("Computational agent list not found",e);
    		throw new SMComputationalAgentInitializationException(
					"Algorithm requested not found" + cac.getValue());
    	}
    	
	}
	
	private void initComputation(SMComputationConfig computationConfig,
			String algorithm, AlgorithmConfiguration algoConfig, long computationId) 
	throws SMComputationalAgentInitializationException, SMResourcesNotAvailableException {
		
		logger.debug(" GET ComputationalAgent List ...");

		// TODO Ecological engine library throws an exception
		// if algoConfig has numberOfResources null so set temporarily 1 as numberOfResources  
		
		algoConfig.setNumberOfResources(1);
		
		List<? extends ComputationalAgent> agents = getComputationalAgentsAvailable(computationConfig, algoConfig);	
		
		logger.debug(" FOUND Generetors List with size ..." + agents);
		for (ComputationalAgent agent : agents) {
			
			logger.debug("INFRASTRACTURE for ComputationalAgent found : "+ agent.getInfrastructure().toString());
			
			switch (agent.getInfrastructure()) {
		
			case D4SCIENCE : {
				
				logger.debug("Start D4Science computation");
				
				if (!ComputationFactory.getFactoryResource().
				setD4ScienceComputation()){
					logger.debug("D4Science resource not available");
					break;
				}
				
				try {
					
					SMPersistenceManager.setComputationalInfrastructure(
							computationId, INFRASTRUCTURE.D4SCIENCE);
				
					String infra = (String)GHNContext.getContext().
					getProperty(GHNContext.INFRASTRUCTURE_NAME, true);

					algoConfig.setGcubeScope("/"+infra);
					
					logger.debug("Retrieve ComputationalAgent parameters .... ");
					List<StatisticalType> parameters = agent.getInputParameters();
					setServiceParameters(computationConfig, algoConfig, parameters);
					agent.setConfiguration(algoConfig);	
					startComputation(computationId, INFRASTRUCTURE.D4SCIENCE, agent);
					logger.debug("Computation started in D4Science ... ");
					
					return;
				} catch (Exception e) {
	    			
					//Clean monitor resources
					logger.error("Start computation failed", e);
	    			cleanResourcesComputational(INFRASTRUCTURE.D4SCIENCE,computationId);
	    			throw new SMComputationalAgentInitializationException(
	    					"ComputationalAgent initialization failed " + e.getMessage());
	    		} 
				
			}
			
			case LOCAL: {
								
				int resources =  ComputationFactory.getFactoryResource().
				setLocalResourcesAvailable(String.valueOf(computationId), computationConfig.getAlgorithm());

				if (resources <= 0) 
					throw new SMResourcesNotAvailableException("Local Resources not available");
				
				try {
					
					logger.debug("Computation started in LOCAL ...");
					SMPersistenceManager.setComputationalInfrastructure(
							computationId, INFRASTRUCTURE.LOCAL);
					
					logger.debug("Set number of resources ");
					algoConfig.setNumberOfResources(resources);
					agent.setConfiguration(algoConfig);	
					startComputation(computationId, INFRASTRUCTURE.LOCAL, agent);
					
					return;
				} catch (Exception e) {
	    			//Clean monitor resources
					logger.error("Start computation failed", e);
	    			cleanResourcesComputational(INFRASTRUCTURE.LOCAL,computationId);
	    			throw new SMComputationalAgentInitializationException(
	    					"ComputationalAgent initialization failed " + e.getMessage());
	    		} 
				
			}
			}
		}
		
		throw new SMComputationalAgentInitializationException("Computation initialization failed");
					
	}
}
