/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.experimentspace;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.access.queueManager.FactoryConfiguration;
import org.gcube.data.access.queueManager.QueueItemHandler;
import org.gcube.data.access.queueManager.QueueType;
import org.gcube.data.access.queueManager.impl.QueueConsumerFactory;
import org.gcube.data.access.queueManager.model.RequestItem;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.experimentspace.AlgorithmCategory;
import org.gcube.data.analysis.statisticalmanager.experimentspace.computation.ComputationContext;
import org.gcube.data.analysis.statisticalmanager.experimentspace.computation.ComputationResource;
import org.gcube.data.analysis.statisticalmanager.persistence.RuntimeResourceManager;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationRequest;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.processing.factories.ClusterersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.EvaluatorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ModelersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationalAgentClass;

public class ComputationFactoryResource
extends GCUBEWSResource {
    static GCUBELog logger = new GCUBELog(ComputationFactoryResource.class);
    private static final String SERVICE = "STATISTICAL_MANAGER";
    private static final float RESOURCES_RATE_DISTRIBUTIONS = 0.8f;
    private static final float RESOURCES_RATE_EVALUATORS = 0.1f;
    private static final int RESOURCES_CONSTANT_MODELS = 1;
    private static int D4SCIENCE_COMPUTATIONS = 0;
    public static final String MESSAGE_COMPUTATION_ID = "computationId";
    public static final String MESSAGE_SCOPE = "scope";
    public static final String MESSAGE_REQUEST = "request";
    public static final String QUEUE = "GHN";
    public static FactoryConfiguration queueConfig;
    private static HashMap<String, Integer> busyLocalResources;

    protected void initialise(Object ... arg0) throws Exception {
        busyLocalResources = new HashMap();
        String infra = (String)GHNContext.getContext().getProperty("infrastructure", new boolean[]{true});
        Set set = GCUBEScope.getScope((String)("/" + infra)).getServiceMap().getEndpoints((Object)"MessageBroker");
        String url_broker = ((EndpointReferenceType)set.toArray()[0]).getAddress().toString();
        queueConfig = new FactoryConfiguration(infra, SERVICE, url_broker, null, null);
        queueConfig.setInitialRedeliveryDelay(3000L);
        queueConfig.setMaximumRedeliveries(-1);
        queueConfig.setUseExponentialRedelivery(false);
        RuntimeResourceManager.initializeDataBase();
        QueueConsumerFactory consumerFactory = QueueConsumerFactory.get((FactoryConfiguration)queueConfig);
        QueueItemHandler<RequestItem> handler = new QueueItemHandler<RequestItem>(){

            public void handleQueueItem(RequestItem item) throws Exception {
                logger.debug((Object)("Message received" + item.getId()));
                SMComputationRequest request = (SMComputationRequest)item.getParameters().get(ComputationFactoryResource.MESSAGE_REQUEST);
                long computationId = (Long)item.getParameters().get(ComputationFactoryResource.MESSAGE_COMPUTATION_ID);
                logger.debug((Object)("ComputationId " + computationId));
                GCUBEStatefulPortTypeContext stfctx = ComputationContext.getContext();
                logger.debug((Object)("User" + request.getUser()));
                GCUBEWSResourceKey key = stfctx.makeKey(request.getUser());
                logger.debug((Object)("Scope " + (String)item.getParameters().get(ComputationFactoryResource.MESSAGE_SCOPE)));
                String scope = (String)item.getParameters().get(ComputationFactoryResource.MESSAGE_SCOPE);
                ComputationContext.getContext().getServiceContext().setScope(Thread.currentThread(), GCUBEScope.getScope((String)scope));
                ComputationResource wsResource = (ComputationResource)ComputationContext.getContext().getWSHome().create(key, new Object[]{request.getUser(), scope});
                logger.debug((Object)"Resource created");
                wsResource.executeComputation(request.getConfig(), computationId);
            }

            public void close() {
            }
        };
        consumerFactory.register(QUEUE, QueueType.REQUEST, (QueueItemHandler)handler);
    }

    private int getLocalResourcesNeeded(SMAlgorithm algorithm) {
        int resources = 0;
        resources = algorithm.getCategory().equals(ComputationalAgentClass.DISTRIBUTIONS.toString()) ? (int)Math.ceil((float)this.getLocalResourcesFree() * 0.8f) : (algorithm.getCategory().equals(ComputationalAgentClass.EVALUATORS.toString()) ? (int)Math.ceil((float)this.getLocalResourcesFree() * 0.1f) : 1);
        return resources;
    }

    private int allLocalResources() {
        return Runtime.getRuntime().availableProcessors();
    }

    private int localResourcesBusy() {
        int result = 0;
        for (Map.Entry<String, Integer> entry : busyLocalResources.entrySet()) {
            result += entry.getValue().intValue();
        }
        return result;
    }

    public synchronized int setLocalResourcesAvailable(String agentId, SMAlgorithm algorithm) {
        int resourcesNeeded = this.getLocalResourcesNeeded(algorithm);
        int resourcesBusy = this.localResourcesBusy();
        int resourcesFree = this.allLocalResources() - resourcesBusy;
        logger.debug((Object)("---------> Resources needed :" + resourcesNeeded));
        logger.debug((Object)("---------> Resources busy   :" + resourcesBusy));
        if (resourcesNeeded == 0 || resourcesFree < resourcesNeeded) {
            return 0;
        }
        busyLocalResources.put(agentId, resourcesNeeded);
        return resourcesNeeded;
    }

    public synchronized void cleanLocalResourcesComputational(String genId) {
        logger.debug((Object)(" ---------- Resources clean up called ----" + busyLocalResources));
        busyLocalResources.remove(genId);
        logger.debug((Object)(" ---------- Resources busy " + busyLocalResources));
    }

    public synchronized int getLocalResourcesFree() {
        return this.allLocalResources() - this.localResourcesBusy();
    }

    public static String getConfigPath() {
        return ServiceContext.getContext().getProperty("configDir", new boolean[0]) + "/cfg/";
    }

    public List<StatisticalType> getListParameters(String category, String algorithmName) throws Exception {
        switch (AlgorithmCategory.valueOf(category)) {
            case DISTRIBUTIONS: {
                return GeneratorsFactory.getAlgorithmParameters((String)ComputationFactoryResource.getConfigPath(), (String)algorithmName);
            }
            case EVALUATORS: {
                return EvaluatorsFactory.getEvaluatorParameters((String)ComputationFactoryResource.getConfigPath(), (String)algorithmName);
            }
            case MODELS: {
                return ModelersFactory.getModelParameters((String)ComputationFactoryResource.getConfigPath(), (String)algorithmName);
            }
            case TRANSDUCERS: {
                return TransducerersFactory.getTransducerParameters((String)ComputationFactoryResource.getConfigPath(), (String)algorithmName);
            }
            case CLUSTERERS: {
                return ClusterersFactory.getClustererParameters((String)ComputationFactoryResource.getConfigPath(), (String)algorithmName);
            }
        }
        throw new Exception();
    }

    public String getAgorithmDescription(String category, String algorithmName) throws Exception {
        switch (AlgorithmCategory.valueOf(category)) {
            case DISTRIBUTIONS: {
                return GeneratorsFactory.getDescription((String)ComputationFactoryResource.getConfigPath(), (String)algorithmName);
            }
            case EVALUATORS: {
                return EvaluatorsFactory.getDescription((String)ComputationFactoryResource.getConfigPath(), (String)algorithmName);
            }
            case MODELS: {
                return ModelersFactory.getDescription((String)ComputationFactoryResource.getConfigPath(), (String)algorithmName);
            }
            case TRANSDUCERS: {
                return TransducerersFactory.getDescription((String)ComputationFactoryResource.getConfigPath(), (String)algorithmName);
            }
            case CLUSTERERS: {
                return ClusterersFactory.getDescription((String)ComputationFactoryResource.getConfigPath(), (String)algorithmName);
            }
        }
        throw new Exception();
    }

    public synchronized boolean setD4ScienceComputation() {
        if (D4SCIENCE_COMPUTATIONS < 2) {
            ++D4SCIENCE_COMPUTATIONS;
            return true;
        }
        return false;
    }

    public synchronized void cleanD4ScienceComputation() {
        --D4SCIENCE_COMPUTATIONS;
    }
}

