/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.proxies;

import java.util.Arrays;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.AsyncProxyDelegate;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.common.clients.gcore.Utils;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDSL;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerFactory;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerService;
import org.gcube.data.analysis.statisticalmanager.stubs.ComputationFactoryStub;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMAlgorithmsRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMComputationRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMComputations;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMComputationsRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMListGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMOperationStatus;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMParameters;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMTypeParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMComputation;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMOperationInfo;

public class StatisticalManagerDefaultFactory
implements StatisticalManagerFactory {
    public static GCUBELog logger = new GCUBELog(StatisticalManagerDefaultFactory.class);
    private final AsyncProxyDelegate<ComputationFactoryStub> delegate;

    public StatisticalManagerDefaultFactory(ProxyDelegate<ComputationFactoryStub> delegate) {
        this.delegate = new AsyncProxyDelegate(delegate);
    }

    private W3CEndpointReference getEPRComputationResource(String computationId) {
        W3CEndpointReference epr = null;
        try {
            GCUBEScope scope = GCUBEScope.getScope((String)ScopeProvider.instance.get());
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            WSResourceQuery wsquery = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
            wsquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//gc:ServiceName", "statistical-manager-gcubews")});
            EndpointReferenceType ert = null;
            for (RPDocument d : client.execute((ISQuery)wsquery, scope)) {
                for (String value : d.evaluate("//computation/text()")) {
                    if (!computationId.equals(value)) continue;
                    ert = d.getEndpoint();
                    break;
                }
                if (ert == null) continue;
                epr = Utils.convert(ert);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return epr;
    }

    @Override
    public SMListGroupedAlgorithms getAlgorithms(SMTypeParameter ... typeParameters) {
        SMTypeParameter[] list = typeParameters;
        final SMAlgorithmsRequest request = new SMAlgorithmsRequest(Arrays.asList(list));
        Call<ComputationFactoryStub, SMListGroupedAlgorithms> call = new Call<ComputationFactoryStub, SMListGroupedAlgorithms>(){

            public SMListGroupedAlgorithms call(ComputationFactoryStub endpoint) throws Exception {
                System.out.println("call service getAlgorihtms");
                return endpoint.getAlgorithms(request);
            }
        };
        try {
            return (SMListGroupedAlgorithms)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public SMOperationInfo getComputationInfo(String computationId, String user) {
        W3CEndpointReference epr = this.getEPRComputationResource(computationId);
        if (epr == null) {
            SMComputation computation = this.getComputation(computationId);
            SMOperationInfo info = new SMOperationInfo();
            int index = computation.operationStatus();
            info.status(index);
            info.percentage(String.valueOf(0));
            switch (SMOperationStatus.values()[index]) {
                case COMPLETED: {
                    info.percentage(String.valueOf(100));
                    break;
                }
                case FAILED: {
                    info.percentage(String.valueOf(100));
                    break;
                }
            }
            return info;
        }
        StatisticalManagerService service = (StatisticalManagerService)StatisticalManagerDSL.stateful().at(epr).build();
        return service.getComputationInfo(computationId);
    }

    @Override
    public SMParameters getAlgorithmParameters(final String algorithm) {
        Call<ComputationFactoryStub, SMParameters> call = new Call<ComputationFactoryStub, SMParameters>(){

            public SMParameters call(ComputationFactoryStub endpoint) throws Exception {
                return endpoint.getAlgorithmParameters(algorithm);
            }
        };
        try {
            return (SMParameters)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public SMComputations getComputations(final String user, final SMTypeParameter ... typeParameters) {
        Call<ComputationFactoryStub, SMComputations> call = new Call<ComputationFactoryStub, SMComputations>(){

            public SMComputations call(ComputationFactoryStub endpoint) throws Exception {
                SMComputationsRequest request = new SMComputationsRequest();
                request.user(user);
                request.page(15);
                request.parameters(Arrays.asList(typeParameters));
                return endpoint.getComputations(request);
            }
        };
        try {
            return (SMComputations)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public String executeComputation(final SMComputationRequest requestComputation) {
        Call<ComputationFactoryStub, String> call = new Call<ComputationFactoryStub, String>(){

            public String call(ComputationFactoryStub endpoint) throws Exception {
                return endpoint.executeComputation(requestComputation);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public SMComputation getComputation(final String computationId) {
        Call<ComputationFactoryStub, SMComputation> call = new Call<ComputationFactoryStub, SMComputation>(){

            public SMComputation call(ComputationFactoryStub endpoint) throws Exception {
                return endpoint.getComputation(computationId);
            }
        };
        try {
            return (SMComputation)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public void removeComputation(final String computationId) {
        W3CEndpointReference epr = this.getEPRComputationResource(computationId);
        if (epr == null) {
            Call<ComputationFactoryStub, JAXWSUtils.Empty> call = new Call<ComputationFactoryStub, JAXWSUtils.Empty>(){

                public JAXWSUtils.Empty call(ComputationFactoryStub endpoint) throws Exception {
                    endpoint.removeComputation(computationId);
                    return new JAXWSUtils.Empty();
                }
            };
            try {
                this.delegate.make((Call)call);
                return;
            }
            catch (Exception e) {
                throw FaultDSL.again((Throwable)e).asServiceException();
            }
        }
        StatisticalManagerService service = (StatisticalManagerService)StatisticalManagerDSL.stateful().at(epr).build();
        service.removeComputation(computationId);
    }

    @Override
    public SMListGroupedAlgorithms getAlgorithmsUser(SMTypeParameter ... typeParameters) {
        SMTypeParameter[] list = typeParameters;
        final SMAlgorithmsRequest request = new SMAlgorithmsRequest(Arrays.asList(list));
        Call<ComputationFactoryStub, SMListGroupedAlgorithms> call = new Call<ComputationFactoryStub, SMListGroupedAlgorithms>(){

            public SMListGroupedAlgorithms call(ComputationFactoryStub endpoint) throws Exception {
                return endpoint.getAlgorithmsUser(request);
            }
        };
        try {
            return (SMListGroupedAlgorithms)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public String resubmitComputation(final String computationId) {
        Call<ComputationFactoryStub, String> call = new Call<ComputationFactoryStub, String>(){

            public String call(ComputationFactoryStub endpoint) throws Exception {
                return endpoint.resubmitComputation(computationId);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

