package org.gcube.data.analysis.statisticalmanager.plugins;


import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.data.analysis.statisticalmanager.exception.ResourceNotFoundException;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDefaultDataSpace;
import org.gcube.data.analysis.statisticalmanager.stubs.DataSpacePortType;
import org.gcube.data.analysis.statisticalmanager.stubs.SMResourceNotFoundFault;
import org.gcube.data.analysis.statisticalmanager.stubs.service.DataSpaceServiceAddressingLocator;




public class StatisticalManagerDataSpacePlugin extends AbstractPlugin<DataSpacePortType, StatisticalManagerDefaultDataSpace> {

	private static final String SERVICE_NAME = "gcube/data/analysis/statisticalmanager/statisticalmanagerdataspace";

	public StatisticalManagerDataSpacePlugin() {
		super(SERVICE_NAME);
		
	}

	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		// TODO Auto-generated method stub
	//	fault.printStackTrace();
		
		if (fault instanceof SMResourceNotFoundFault) {
			return new ResourceNotFoundException();
		}
		return fault;
	}

	@Override
	public DataSpacePortType resolve(EndpointReferenceType address,
			ProxyConfig<?, ?> config) throws Exception {
		return new DataSpaceServiceAddressingLocator().getDataSpacePortTypePort(address);
	}

	@Override
	public StatisticalManagerDefaultDataSpace newProxy(
			ProxyDelegate<DataSpacePortType> delegate) {
		return new StatisticalManagerDefaultDataSpace(delegate);
	}

}
