package org.gcube.data.analysis.statisticalmanager.proxies;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.common.core.types.VOID;
import org.gcube.data.analysis.statisticalmanager.stubs.ComputationPortType;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationConfig;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMAbstractResource;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMOperationInfo;

public class StatisticalManagerDefaultService implements StatisticalManagerService{

	private final ProxyDelegate<ComputationPortType> delegate;
	
	public StatisticalManagerDefaultService(ProxyDelegate<ComputationPortType> delegate) {
		super();
		this.delegate = delegate;
	}

	@Override
	public SMOperationInfo getComputationInfo(final String computationId) {
		Call<ComputationPortType,SMOperationInfo> call = new Call<ComputationPortType, SMOperationInfo>(){
			
			@Override
			public SMOperationInfo call(ComputationPortType endpoint) throws Exception {
				return endpoint.getComputationInfo(computationId);
			};
		};
		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

	@Override
	public SMAbstractResource getComputationOutput(final String computationId) {
		Call<ComputationPortType, SMAbstractResource> call = new Call<ComputationPortType, SMAbstractResource>() {

			@Override
			public SMAbstractResource call(ComputationPortType endpoint)
					throws Exception {
				return endpoint.getOutput(computationId);
			}
		};
		
		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

		@Override
	public void removeComputation(final String computationId) {
		Call<ComputationPortType, VOID> call = new Call<ComputationPortType, VOID>() {

			@Override
			public VOID call(ComputationPortType endpoint)
					throws Exception {
				return endpoint.remove(computationId);
			}
			
		};
		
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

	@Override
	public String executeComputation(SMComputationConfig computationConfig) {
		
			Call<ComputationPortType, String> call = new Call<ComputationPortType, String>(){
			
			@Override
			public String call(ComputationPortType endpoint) throws Exception {
				
				return null;
				//return endpoint.executeComputation(computationConfig);
			};
		};
		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}
	
}
