/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.excel.validation.table.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.gcube.data.analysis.excel.data.TimeSeriesColumn;
import org.gcube.data.analysis.excel.validation.table.ColumnValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableColumnValidator
implements ColumnValidator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<TimeSeriesColumn.DATA_TYPE, LinkedList<TimeSeriesColumn>> categorizedColumns;

    public TableColumnValidator(Set<TimeSeriesColumn> columns) {
        this.logger.debug("Generating column validator for table");
        this.categorizedColumns = this.categorizeColumns(columns);
    }

    private HashMap<TimeSeriesColumn.DATA_TYPE, LinkedList<TimeSeriesColumn>> categorizeColumns(Set<TimeSeriesColumn> tableColumns) {
        LinkedList<TimeSeriesColumn> clonedColumns = new LinkedList<TimeSeriesColumn>(tableColumns);
        HashMap<TimeSeriesColumn.DATA_TYPE, LinkedList<TimeSeriesColumn>> result = new HashMap<TimeSeriesColumn.DATA_TYPE, LinkedList<TimeSeriesColumn>>();
        for (TimeSeriesColumn.DATA_TYPE dataType : TimeSeriesColumn.DATA_TYPE.values()) {
            result.put(dataType, new LinkedList());
        }
        for (TimeSeriesColumn column : clonedColumns) {
            LinkedList<TimeSeriesColumn> columnsSet = result.get((Object)column.getDataType());
            columnsSet.add(column);
        }
        return result;
    }

    @Override
    public void removeColumn(TimeSeriesColumn column, TimeSeriesColumn.DATA_TYPE ... dataTypes) {
        if (dataTypes == null || dataTypes.length == 0) {
            dataTypes = TimeSeriesColumn.DATA_TYPE.values();
        }
        this.logger.debug("Removing validated column " + column.getName());
        boolean removed = false;
        for (int index = 0; index < dataTypes.length && !removed; ++index) {
            TimeSeriesColumn.DATA_TYPE dataType = dataTypes[index];
            this.logger.debug("Checking " + (Object)((Object)dataType));
            LinkedList<TimeSeriesColumn> columns = this.categorizedColumns.get((Object)dataType);
            if (columns == null) continue;
            removed = columns.remove(column);
            this.logger.debug("Column " + (removed ? "removed" : "not found among " + (Object)((Object)dataType)));
        }
    }

    @Override
    public int size(TimeSeriesColumn.DATA_TYPE ... dataTypes) {
        if (dataTypes == null || dataTypes.length == 0) {
            dataTypes = TimeSeriesColumn.DATA_TYPE.values();
        }
        int size = 0;
        for (TimeSeriesColumn.DATA_TYPE dataType : dataTypes) {
            LinkedList<TimeSeriesColumn> columns = this.categorizedColumns.get((Object)dataType);
            if (columns == null) continue;
            size += columns.size();
        }
        return size;
    }

    @Override
    public Iterator<TimeSeriesColumn> iterator(TimeSeriesColumn.DATA_TYPE ... dataTypes) {
        if (dataTypes == null || dataTypes.length == 0) {
            dataTypes = TimeSeriesColumn.DATA_TYPE.values();
        }
        HashSet<TimeSeriesColumn> columnSet = new HashSet<TimeSeriesColumn>();
        for (TimeSeriesColumn.DATA_TYPE dataType : dataTypes) {
            LinkedList<TimeSeriesColumn> columns = this.categorizedColumns.get((Object)dataType);
            if (columns == null) continue;
            columnSet.addAll(columns);
        }
        return columnSet.iterator();
    }
}

