/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.excel.validation.table;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gcube.data.analysis.excel.data.TimeSeriesColumn;
import org.gcube.data.analysis.excel.data.TimeSeriesTable;
import org.gcube.data.analysis.excel.validation.report.ValidationReport;
import org.gcube.data.analysis.excel.validation.sdmx.SDMXStructureLoader;
import org.gcube.data.analysis.excel.validation.sdmx.eceptions.SDMXLoaderException;
import org.gcube.data.analysis.excel.validation.table.ColumnValidator;
import org.sdmxsource.sdmx.api.constants.ATTRIBUTE_ATTACHMENT_LEVEL;
import org.sdmxsource.sdmx.api.model.beans.base.ComponentBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeListBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionListBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableValidator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SDMXStructureLoader sdmxLoader;
    private String locale;
    private final String DEFAULT_LOCALE = "en";

    public TableValidator(String locale) {
        this.locale = locale == null ? "en" : locale;
    }

    public void setSDMXLoader(SDMXStructureLoader sdmxLoader) {
        this.sdmxLoader = sdmxLoader;
    }

    public ValidationReport validate(TimeSeriesTable table) {
        this.logger.debug("Validation started");
        DataStructureBean dsd = this.sdmxLoader.getDataStructureDefinition();
        this.logger.debug("Using dsd " + dsd.getName() + " version " + dsd.getVersion());
        LinkedList<ComponentBean> measureBeans = new LinkedList<ComponentBean>();
        LinkedList<ComponentBean> timeDimensionBeans = new LinkedList<ComponentBean>();
        LinkedList<ComponentBean> frequencyDimensionBeans = new LinkedList<ComponentBean>();
        LinkedList<ComponentBean> dimensionBeans = new LinkedList<ComponentBean>();
        LinkedList<ComponentBean> attributeBeans = new LinkedList<ComponentBean>();
        String agency = dsd.getAgencyId();
        this.logger.debug("Agency = " + agency);
        this.logger.debug("Getting dimensions");
        this.categorizeDimensionBeans(dsd, measureBeans, timeDimensionBeans, frequencyDimensionBeans, dimensionBeans);
        this.logger.debug("Getting attributes");
        this.getAttributes(dsd, attributeBeans);
        ColumnValidator columnValidator = table.generateColumnValidator();
        try {
            this.logger.debug("Validating measure columns: looking for numeric columns in the table");
            ValidationReport measureReport = this.validateMeasures(agency, measureBeans, columnValidator);
            if (measureReport.getResult() != ValidationReport.RESULT.OK) {
                this.logger.debug("Measure validation failed");
                return measureReport;
            }
            this.logger.debug("Measure columns validation succeeded");
            this.logger.debug("Validating time columns: using time, generic and remaining numeric columns");
            ValidationReport timeReport = this.validateTime(agency, timeDimensionBeans, columnValidator);
            if (timeReport.getResult() != ValidationReport.RESULT.OK) {
                this.logger.debug("Time validation failed");
                return timeReport;
            }
            this.logger.debug("Time validation succeeded");
            if (!dimensionBeans.isEmpty()) {
                this.logger.debug("Validating remaining dimensions");
                ValidationReport genericDimensionReport = this.validateGenericDimensions(agency, dimensionBeans, columnValidator);
                if (genericDimensionReport.getResult() != ValidationReport.RESULT.OK) {
                    this.logger.debug("Dimension validation failed");
                    return genericDimensionReport;
                }
                this.logger.debug("Generic dimensions validation succeeded");
            }
            if (!attributeBeans.isEmpty()) {
                this.logger.debug("Validating observation attributes");
                ValidationReport attributesReport = this.validateAttributes(agency, attributeBeans, columnValidator);
                if (attributesReport.getResult() != ValidationReport.RESULT.OK) {
                    this.logger.debug("Attribute validation failed");
                    return attributesReport;
                }
                this.logger.debug("Attribute validation succeeded");
            }
            if (columnValidator.size(new TimeSeriesColumn.DATA_TYPE[0]) > 0) {
                this.logger.error("Extra columns");
                Iterator<TimeSeriesColumn> remainingColumns = columnValidator.iterator(new TimeSeriesColumn.DATA_TYPE[0]);
                StringBuilder names = new StringBuilder();
                while (remainingColumns.hasNext()) {
                    names.append(remainingColumns.next().getName()).append(" ");
                }
                return new ValidationReport(ValidationReport.RESULT.INVALID_N_COLUMNS, "Some colums are not present in the registry: " + names);
            }
            this.logger.debug("Validation succeeded");
            return new ValidationReport(ValidationReport.RESULT.OK, null);
        }
        catch (Exception e) {
            this.logger.error("Internal error " + e);
            return new ValidationReport(ValidationReport.RESULT.INTERNAL_ERROR, e.getMessage());
        }
    }

    private void categorizeDimensionBeans(DataStructureBean dsd, LinkedList<ComponentBean> measureBeans, LinkedList<ComponentBean> timeDimensionBeans, LinkedList<ComponentBean> frequencyDimensionBeans, LinkedList<ComponentBean> dimensionBeans) {
        this.logger.debug("Categorizing beans...");
        DimensionListBean dimensionList = dsd.getDimensionList();
        List dimensions = dimensionList.getDimensions();
        if (dimensions != null) {
            this.logger.debug("Dimension list found");
            boolean primaryDimensionFound = false;
            for (DimensionBean dimension : dimensions) {
                if (dimension.isMeasureDimension()) {
                    this.logger.debug("Found measure dimension");
                    String id = dimension.getId();
                    this.logger.debug("Measure dimension id " + id);
                    if (id.equals("OBS_VALUE")) {
                        this.logger.debug("Primary dimension found");
                        primaryDimensionFound = true;
                    }
                    measureBeans.add((ComponentBean)dimension);
                    continue;
                }
                if (dimension.isTimeDimension()) {
                    this.logger.debug("Found time dimension");
                    timeDimensionBeans.add((ComponentBean)dimension);
                    continue;
                }
                if (dimension.isFrequencyDimension()) {
                    this.logger.debug("Found frequency");
                    frequencyDimensionBeans.add((ComponentBean)dimension);
                    continue;
                }
                this.logger.debug("Found standard dimension");
                dimensionBeans.add((ComponentBean)dimension);
            }
            if (!primaryDimensionFound) {
                this.logger.debug("Getting primary measure");
                measureBeans.add((ComponentBean)dsd.getPrimaryMeasure());
                this.logger.debug("Primary measure added");
            }
        }
    }

    private void getAttributes(DataStructureBean dsd, LinkedList<ComponentBean> attributeBeans) {
        this.logger.debug("Getting attribute columns");
        AttributeListBean attributeList = dsd.getAttributeList();
        List attributes = attributeList.getAttributes();
        if (attributes != null) {
            for (AttributeBean attribute : attributes) {
                if (attribute.getAttachmentLevel() == ATTRIBUTE_ATTACHMENT_LEVEL.OBSERVATION) {
                    this.logger.debug("Found observation attribute " + attribute.getId());
                    attributeBeans.add((ComponentBean)attribute);
                    continue;
                }
                this.logger.warn("Attribute " + attribute.getId() + " is not referred to observation: attribute based validation not implemented yet");
            }
        }
    }

    private ValidationReport validateAttributes(String agency, List<ComponentBean> attributes, ColumnValidator columnValidator) throws Exception {
        this.logger.debug("Validating attributes");
        String invalidComponentID = this.validateColumns(agency, attributes, columnValidator, new TimeSeriesColumn.DATA_TYPE[0]);
        if (invalidComponentID == null) {
            return new ValidationReport(ValidationReport.RESULT.OK, null);
        }
        return new ValidationReport(ValidationReport.RESULT.ATTRIBUTE_NOT_FOUND, "Attribute column " + invalidComponentID + " was expected but has not been found");
    }

    private ValidationReport validateGenericDimensions(String agency, List<ComponentBean> dimensions, ColumnValidator columnValidator) throws Exception {
        this.logger.debug("Validating generic dimensions");
        String invalidComponentID = this.validateColumns(agency, dimensions, columnValidator, new TimeSeriesColumn.DATA_TYPE[0]);
        if (invalidComponentID == null) {
            return new ValidationReport(ValidationReport.RESULT.OK, null);
        }
        return new ValidationReport(ValidationReport.RESULT.DIMENSION_NOT_FOUND, "Dimension column " + invalidComponentID + " was expected but has not been found");
    }

    private ValidationReport validateTime(String agency, List<ComponentBean> timeDimensionBeans, ColumnValidator columnValidator) throws Exception {
        this.logger.debug("Validating time dimension (time, numeric and generic type)");
        if (this.validateColumns(agency, timeDimensionBeans, columnValidator, TimeSeriesColumn.DATA_TYPE.TIME, TimeSeriesColumn.DATA_TYPE.NUMERIC, TimeSeriesColumn.DATA_TYPE.GENERIC, TimeSeriesColumn.DATA_TYPE.BLANK) == null) {
            return new ValidationReport(ValidationReport.RESULT.OK, null);
        }
        return new ValidationReport(ValidationReport.RESULT.TIME_DIMENSION_NOT_FOUND, "Time dimension column was expected but has not been found");
    }

    private String validateColumns(String agency, List<ComponentBean> componentBeanList, ColumnValidator columnValidator, TimeSeriesColumn.DATA_TYPE ... dataTypes) throws SDMXLoaderException {
        this.logger.debug("Validating current columns");
        String invalidComponentId = null;
        Iterator<ComponentBean> componentsBeanIterator = componentBeanList.iterator();
        while (componentsBeanIterator.hasNext() && invalidComponentId == null) {
            ComponentBean componentBean = componentsBeanIterator.next();
            this.logger.debug("Validating component " + componentBean.getId());
            String conceptName = this.getConceptName(agency, componentBean);
            boolean found = false;
            Iterator<TimeSeriesColumn> columnsIterator = columnValidator.iterator(dataTypes);
            while (columnsIterator.hasNext() && !found) {
                TimeSeriesColumn currentColumn = columnsIterator.next();
                this.logger.debug("Checking local column " + currentColumn);
                if (!currentColumn.getName().equalsIgnoreCase(conceptName)) continue;
                found = true;
                columnValidator.removeColumn(currentColumn, dataTypes);
                this.logger.debug("Valid Column found");
            }
            if (found) continue;
            invalidComponentId = componentBean.getId();
        }
        this.logger.debug("Operation completed");
        return invalidComponentId;
    }

    private ValidationReport validateMeasures(String agency, List<ComponentBean> measureBeans, ColumnValidator columnValidator) throws Exception {
        TimeSeriesColumn.DATA_TYPE[] dataType = new TimeSeriesColumn.DATA_TYPE[]{TimeSeriesColumn.DATA_TYPE.NUMERIC, TimeSeriesColumn.DATA_TYPE.BLANK};
        this.logger.debug("Considering as measure columns columns " + dataType);
        int measureColumnsSize = columnValidator.size(dataType);
        if (measureBeans.size() > measureColumnsSize) {
            String informationReport = "Found " + measureColumnsSize + " potential measure columns:  " + measureBeans.size() + " at least numeric columns expected";
            this.logger.debug(informationReport);
            return new ValidationReport(ValidationReport.RESULT.INVALID_N_COLUMNS, informationReport);
        }
        String invalidComponentID = this.validateColumns(agency, measureBeans, columnValidator, dataType);
        if (invalidComponentID == null) {
            return new ValidationReport(ValidationReport.RESULT.OK, null);
        }
        return new ValidationReport(ValidationReport.RESULT.DIMENSION_NOT_FOUND, "A measure dimension " + invalidComponentID + " was expected but has not been found");
    }

    private String getConceptName(String agency, ComponentBean measureBean) throws SDMXLoaderException {
        this.logger.debug("Looking for measure " + measureBean.getId());
        CrossReferenceBean crossReferenceBean = measureBean.getConceptRef();
        ConceptSchemeBean conceptScheme = this.sdmxLoader.getAssociatedConceptScheme(agency, crossReferenceBean);
        ConceptBean concept = conceptScheme.getItemById(measureBean.getConceptRef().getIdentifiableIds()[0]);
        Iterator conceptNames = concept.getNames().iterator();
        String conceptName = null;
        while (conceptName == null && conceptNames.hasNext()) {
            TextTypeWrapper textTypeName = (TextTypeWrapper)conceptNames.next();
            if (!textTypeName.getLocale().equalsIgnoreCase(this.locale)) continue;
            conceptName = textTypeName.getValue();
        }
        if (conceptName == null) {
            this.logger.warn("Locale " + this.locale + " not available, using default one");
            conceptName = concept.getName();
        }
        this.logger.debug("Concept found: " + conceptName);
        return conceptName;
    }
}

