/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.excel.validation.sdmx.impl;

import java.util.HashMap;
import java.util.Map;
import org.gcube.data.analysis.excel.validation.sdmx.SDMXStructureLoader;
import org.gcube.data.analysis.excel.validation.sdmx.eceptions.SDMXLoaderException;
import org.gcube.datapublishing.sdmx.api.model.SDMXRegistryDescriptor;
import org.gcube.datapublishing.sdmx.api.model.SDMXRegistryInterfaceType;
import org.gcube.datapublishing.sdmx.api.registry.SDMXRegistryClient;
import org.gcube.datapublishing.sdmx.impl.exceptions.SDMXRegistryClientException;
import org.gcube.datapublishing.sdmx.impl.model.SDMXRegistryDescriptorImpl;
import org.gcube.datapublishing.sdmx.impl.registry.FusionRegistryClient;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionRegistrySDMXStructureLoader
implements SDMXStructureLoader {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SDMXRegistryDescriptorImpl descriptor = new SDMXRegistryDescriptorImpl();
    private DataStructureBean dsd;
    private Map<String, ConceptSchemeBean> conceptSchemeMap;
    private FusionRegistryClient registryClient;

    public FusionRegistrySDMXStructureLoader(String registryURL, String username, String password) {
        this.descriptor.setCredentials(username, password);
        this.descriptor.setUrl(SDMXRegistryInterfaceType.RESTV2_1, registryURL);
        this.conceptSchemeMap = new HashMap<String, ConceptSchemeBean>();
    }

    @Override
    public void initDataStructureLoader(String agency, String dsdName, String version) throws SDMXLoaderException {
        this.logger.debug("Loading fusion registry");
        this.registryClient = new FusionRegistryClient((SDMXRegistryDescriptor)this.descriptor);
        this.logger.debug("Loading data structure from Fusion Registry");
        try {
            SdmxBeans dataStructureBeans = this.registryClient.getDataStructure(agency, dsdName, version, SDMXRegistryClient.Detail.full, SDMXRegistryClient.References.all);
            if (dataStructureBeans.getDataStructures().isEmpty()) {
                throw new SDMXLoaderException("Unable to found data Structure");
            }
            this.logger.debug("Data Structure definition found");
            this.dsd = (DataStructureBean)dataStructureBeans.getDataStructures().iterator().next();
        }
        catch (SDMXRegistryClientException e) {
            this.logger.error("Unable to load data from the registry");
            throw new SDMXLoaderException("Unable to load data from the registry", e);
        }
    }

    @Override
    public DataStructureBean getDataStructureDefinition() {
        return this.dsd;
    }

    @Override
    public ConceptSchemeBean getAssociatedConceptScheme(String agency, CrossReferenceBean conceptReference) throws SDMXLoaderException {
        this.logger.debug("Associated with concept " + conceptReference.getFullId());
        String conceptSchemeId = conceptReference.getMaintainableId();
        this.logger.debug("Concept scheme id " + conceptSchemeId);
        String version = conceptReference.getVersion();
        this.logger.debug("Version " + version);
        ConceptSchemeBean conceptScheme = this.conceptSchemeMap.get(conceptSchemeId + "-" + version);
        if (conceptScheme == null) {
            this.logger.debug("Loading new concept scheme");
            try {
                SdmxBeans sdmxBeans = this.registryClient.getConceptScheme(agency, conceptSchemeId, version, SDMXRegistryClient.Detail.full, SDMXRegistryClient.References.none);
                conceptScheme = (ConceptSchemeBean)sdmxBeans.getConceptSchemes().iterator().next();
                this.conceptSchemeMap.put(conceptSchemeId + "-" + version, conceptScheme);
                this.logger.debug("Concept scheme loaded");
            }
            catch (SDMXRegistryClientException e) {
                throw new SDMXLoaderException("Unable to load concept scheme", e);
            }
        }
        return conceptScheme;
    }
}

