/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.excel.validation;

import java.io.InputStream;
import org.gcube.data.analysis.excel.data.TimeSeriesTable;
import org.gcube.data.analysis.excel.data.exceptions.TimeSeriesLoaderException;
import org.gcube.data.analysis.excel.data.loader.TimeSeriesTableLoader;
import org.gcube.data.analysis.excel.validation.report.ValidationReport;
import org.gcube.data.analysis.excel.validation.sdmx.SDMXStructureLoader;
import org.gcube.data.analysis.excel.validation.sdmx.eceptions.SDMXLoaderException;
import org.gcube.data.analysis.excel.validation.table.TableValidator;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SDMXStructureLoader sdmxLoader = null;
    private TimeSeriesTableLoader tableLoader = null;

    public void setLoaders(SDMXStructureLoader sdmxLoader, TimeSeriesTableLoader tableLoader) {
        this.sdmxLoader = sdmxLoader;
        if (this.sdmxLoader == null) {
            throw new NullPointerException("Data Structure Definition loader cannot be null");
        }
        this.tableLoader = tableLoader;
        if (this.tableLoader == null) {
            throw new NullPointerException("Table loader cannot be null");
        }
    }

    public void setDataStructureInformation(String agency, String dsdName, String dsdVersion) throws SDMXLoaderException {
        this.sdmxLoader.initDataStructureLoader(agency, dsdName, dsdVersion);
    }

    public void setExcelData(InputStream stream) throws TimeSeriesLoaderException {
        this.tableLoader.initTable(stream);
    }

    public ValidationReport validateData() {
        this.logger.debug("Validating time series data");
        TimeSeriesTable table = this.tableLoader.getTimeSeries();
        this.logger.debug("Time series " + table.getName());
        DataStructureBean dsd = this.sdmxLoader.getDataStructureDefinition();
        this.logger.debug("Against data structure " + dsd.getId());
        TableValidator validator = new TableValidator("en");
        validator.setSDMXLoader(this.sdmxLoader);
        this.logger.debug("Starting validation");
        ValidationReport report = validator.validate(table);
        this.logger.debug("Operation completed");
        return report;
    }
}

