/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.excel.data.loader.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.gcube.data.analysis.excel.data.TimeSeriesColumn;
import org.gcube.data.analysis.excel.data.TimeSeriesTable;
import org.gcube.data.analysis.excel.data.exceptions.TimeSeriesLoaderException;
import org.gcube.data.analysis.excel.data.factory.CellWrapperFactory;
import org.gcube.data.analysis.excel.data.factory.TimeSeriesTableFactory;
import org.gcube.data.analysis.excel.data.impl.BlankCellWrapper;
import org.gcube.data.analysis.excel.data.impl.GenericCellWrapper;
import org.gcube.data.analysis.excel.data.impl.TimeSeriesColumnImpl;
import org.gcube.data.analysis.excel.data.loader.TimeSeriesTableLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelTimeSeriesLoader
implements TimeSeriesTableLoader {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private TimeSeriesTable table = null;

    @Override
    public void initTable(InputStream stream) throws TimeSeriesLoaderException {
        try {
            this.logger.debug("Loading file stream");
            XSSFWorkbook document = new XSSFWorkbook(stream);
            XSSFSheet sheet = document.getSheetAt(0);
            ArrayList cells = new ArrayList();
            String name = sheet.getSheetName();
            this.logger.debug("Table name " + name);
            Iterator rows = sheet.iterator();
            int nColumns = 0;
            if (rows.hasNext()) {
                this.logger.debug("Parsing headers");
                Row firstRow = (Row)rows.next();
                for (Cell cell : firstRow) {
                    ++nColumns;
                    ArrayList<GenericCellWrapper> cellList = new ArrayList<GenericCellWrapper>();
                    cellList.add(new GenericCellWrapper(TimeSeriesColumn.DATA_TYPE.GENERIC, cell.getStringCellValue()));
                    cells.add(cellList);
                    this.logger.debug("Header cell added");
                }
            } else {
                document.close();
                throw new TimeSeriesLoaderException("Invalid excel table: no header");
            }
            while (rows.hasNext()) {
                int columnIndex = 0;
                Iterator rowCells = ((Row)rows.next()).iterator();
                while (rowCells.hasNext()) {
                    this.logger.debug("Adding data row");
                    Cell cell = (Cell)rowCells.next();
                    int currentColumnIndex = cell.getColumnIndex();
                    this.logger.debug("Current column index " + columnIndex);
                    if (currentColumnIndex >= nColumns) {
                        this.logger.warn("Invalid column: no header present");
                    } else {
                        while (columnIndex < currentColumnIndex) {
                            this.logger.debug("adding an empty cell");
                            ((List)cells.get(columnIndex)).add(new BlankCellWrapper());
                            ++columnIndex;
                        }
                        this.logger.debug("Adding cell " + cell.getCellTypeEnum());
                        ((List)cells.get(columnIndex)).add(CellWrapperFactory.generateCellWrapper(cell));
                    }
                    ++columnIndex;
                    this.logger.debug("Data row added");
                }
            }
            document.close();
            HashSet<TimeSeriesColumn> timeSeriesColumns = new HashSet<TimeSeriesColumn>();
            for (List list : cells) {
                timeSeriesColumns.add(new TimeSeriesColumnImpl(list));
            }
            this.table = TimeSeriesTableFactory.generateTimeSeriesTable(name, timeSeriesColumns);
            this.logger.debug("Table created");
        }
        catch (Exception e) {
            throw new TimeSeriesLoaderException("Unable to load excel file", e);
        }
    }

    @Override
    public TimeSeriesTable getTimeSeries() {
        return this.table;
    }
}

