/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.excel.data.impl;

import java.util.ArrayList;
import java.util.List;
import org.gcube.data.analysis.excel.data.CellWrapper;
import org.gcube.data.analysis.excel.data.TimeSeriesColumn;
import org.gcube.data.analysis.excel.data.exceptions.InvalidColumnException;

public class TimeSeriesColumnImpl
implements TimeSeriesColumn {
    private String name;
    private TimeSeriesColumn.DATA_TYPE dataType;
    private ArrayList<Object> dataValues;

    public TimeSeriesColumnImpl(List<CellWrapper> cells) throws InvalidColumnException {
        if (cells == null || cells.isEmpty()) {
            throw new InvalidColumnException("Cells list empty");
        }
        this.dataValues = new ArrayList();
        this.dataType = TimeSeriesColumn.DATA_TYPE.BLANK;
        CellWrapper headerCell = cells.remove(0);
        try {
            String headerName = (String)headerCell.getValue();
            if (headerName == null || headerName.trim().length() == 0) {
                throw new InvalidColumnException("Empty header name");
            }
            this.name = headerName;
            this.parseDataValues(cells);
        }
        catch (Exception e) {
            throw new InvalidColumnException("Invalid header name", e);
        }
    }

    private void parseDataValues(List<CellWrapper> cells) {
        for (CellWrapper cell : cells) {
            this.dataType = this.dataType.compare(cell.getDataType());
            this.dataValues.add(cell.getValue());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TimeSeriesColumn.DATA_TYPE getDataType() {
        return this.dataType;
    }

    @Override
    public List<Object> getData() {
        return this.dataValues;
    }

    public String toString() {
        StringBuilder textBulder = new StringBuilder("Column name ");
        textBulder.append(this.name);
        if (this.dataType != null) {
            textBulder.append(" data type ").append((Object)this.dataType);
        }
        return textBulder.toString();
    }
}

