/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.excel.data.factory;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.gcube.data.analysis.excel.data.CellWrapper;
import org.gcube.data.analysis.excel.data.TimeSeriesColumn;
import org.gcube.data.analysis.excel.data.impl.BlankCellWrapper;
import org.gcube.data.analysis.excel.data.impl.GenericCellWrapper;

public class CellWrapperFactory {
    public static CellWrapper generateCellWrapper(Cell cell) {
        CellType type = cell.getCellTypeEnum();
        CellWrapper response = null;
        switch (type) {
            case NUMERIC: {
                response = new GenericCellWrapper(TimeSeriesColumn.DATA_TYPE.NUMERIC, cell.getNumericCellValue());
                break;
            }
            case BOOLEAN: {
                response = new GenericCellWrapper(TimeSeriesColumn.DATA_TYPE.GENERIC, cell.getBooleanCellValue());
                break;
            }
            case STRING: {
                if (cell.getStringCellValue().trim().length() != 0) {
                    response = new BlankCellWrapper();
                    break;
                }
                response = new GenericCellWrapper(TimeSeriesColumn.DATA_TYPE.GENERIC, cell.getStringCellValue());
                break;
            }
            default: {
                response = new BlankCellWrapper();
            }
        }
        return response;
    }
}

