package org.gcube.data.analysis.excel.validation.table.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

import org.gcube.data.analysis.excel.data.TimeSeriesColumn;
import org.gcube.data.analysis.excel.data.TimeSeriesColumn.DATA_TYPE;
import org.gcube.data.analysis.excel.validation.table.ColumnValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateColumnValidator implements ColumnValidator
{
	private Logger logger;
	private LinkedList<TimeSeriesColumn> columns;
	
	public TemplateColumnValidator(Set<TimeSeriesColumn> columns) 
	{
		this.logger = LoggerFactory.getLogger(this.getClass());
		this.logger.debug("Generating column validator for template");
		this.columns = new LinkedList<>(columns);
	}
	
	
	
	@Override
	public void removeColumn (TimeSeriesColumn column,DATA_TYPE... dataTypes)
	{
		this.columns.remove(column);
	}
	

	@Override
	public int size (DATA_TYPE... dataTypes)
	{
		return this.columns.size();
	}


	@Override
	public Iterator<TimeSeriesColumn> iterator(DATA_TYPE... dataTypes) {
	
		
		Set<TimeSeriesColumn> columnSet = new HashSet<>(this.columns);
		
		
		return columnSet.iterator();
	}

}
