package org.gcube.data.analysis.excel.validation.table.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

import org.gcube.data.analysis.excel.data.TimeSeriesColumn;
import org.gcube.data.analysis.excel.data.TimeSeriesColumn.DATA_TYPE;
import org.gcube.data.analysis.excel.validation.table.ColumnValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableColumnValidator implements ColumnValidator
{
	private Logger logger;
	private Map<DATA_TYPE, LinkedList<TimeSeriesColumn>> categorizedColumns;
	
	public TableColumnValidator(Set<TimeSeriesColumn> columns) 
	{
		this.logger = LoggerFactory.getLogger(this.getClass());
		this.logger.debug("Generating column validator for table");
		this.categorizedColumns = categorizeColumns (columns);
	}
	
	
	private HashMap<DATA_TYPE, LinkedList<TimeSeriesColumn>> categorizeColumns (Set<TimeSeriesColumn> tableColumns)
	{
		LinkedList<TimeSeriesColumn> clonedColumns = new LinkedList<>(tableColumns);
		HashMap<DATA_TYPE, LinkedList<TimeSeriesColumn>> result = new HashMap<>();
		
		for (DATA_TYPE dataType : TimeSeriesColumn.DATA_TYPE.values())
		{
			result.put(dataType, new LinkedList<>());
		}

		Iterator<TimeSeriesColumn> columnsIterator = clonedColumns.iterator();
		
		while (columnsIterator.hasNext())
		{
			TimeSeriesColumn column = columnsIterator.next();
			LinkedList<TimeSeriesColumn> columnsSet = result.get(column.getDataType());
			columnsSet.add(column);
		}
		
		return result;
	}
	
	@Override
	public void removeColumn (TimeSeriesColumn column,DATA_TYPE... dataTypes)
	{
		if (dataTypes == null || dataTypes.length == 0) dataTypes = TimeSeriesColumn.DATA_TYPE.values();

		this.logger.debug("Removing validated column "+column.getName());
		boolean removed = false;
		int index = 0;
		
		while (index < dataTypes.length && ! removed)
		{
			DATA_TYPE dataType = dataTypes [index];
			this.logger.debug("Checking "+dataType);
			
			 LinkedList<TimeSeriesColumn> columns = this.categorizedColumns.get(dataType);
			 
			 if (columns != null)
			 {
				 
				 removed = columns.remove(column);
				 this.logger.debug("Column "+(removed ? "removed":"not found among "+dataType));
			 }
			 
			 index++;
		}
	}
	

	@Override
	public int size (DATA_TYPE... dataTypes)
	{
		if (dataTypes == null || dataTypes.length == 0) dataTypes = TimeSeriesColumn.DATA_TYPE.values();
		
		int size = 0;
		
		for (DATA_TYPE dataType : dataTypes)
		{
			LinkedList<TimeSeriesColumn> columns = this.categorizedColumns.get(dataType);
			
			if (columns!= null) size = size + columns.size();
		}
		
		return size;
	}


	@Override
	public Iterator<TimeSeriesColumn> iterator(DATA_TYPE... dataTypes) {
	
		if (dataTypes == null || dataTypes.length == 0) dataTypes = TimeSeriesColumn.DATA_TYPE.values();
		
		
		Set<TimeSeriesColumn> columnSet = new HashSet<>();
		
		for (DATA_TYPE dataType : dataTypes)
		{			
			LinkedList<TimeSeriesColumn> columns = this.categorizedColumns.get(dataType);
			
			if (columns!= null)
			{
				columnSet.addAll(columns);
			}
		}
		
		return columnSet.iterator();
	}

}
