package org.gcube.data.analysis.excel.validation.sdmx.impl;

import java.util.HashMap;
import java.util.Map;

import org.gcube.data.analysis.excel.validation.sdmx.SDMXStructureLoader;
import org.gcube.data.analysis.excel.validation.sdmx.eceptions.SDMXLoaderException;
import org.gcube.datapublishing.sdmx.api.model.SDMXRegistryInterfaceType;
import org.gcube.datapublishing.sdmx.api.registry.SDMXRegistryClient.Detail;
import org.gcube.datapublishing.sdmx.api.registry.SDMXRegistryClient.References;
import org.gcube.datapublishing.sdmx.impl.exceptions.SDMXRegistryClientException;
import org.gcube.datapublishing.sdmx.impl.model.SDMXRegistryDescriptorImpl;
import org.gcube.datapublishing.sdmx.impl.registry.FusionRegistryClient;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionRegistrySDMXStructureLoader implements SDMXStructureLoader {

	private Logger logger;
	private SDMXRegistryDescriptorImpl descriptor;
	private DataStructureBean dsd;
	private Map<String, ConceptSchemeBean> conceptSchemeMap;
	private FusionRegistryClient registryClient;

	public  FusionRegistrySDMXStructureLoader(String registryURL, String username, String password) {
		this.logger = LoggerFactory.getLogger(this.getClass());
		this.descriptor = new SDMXRegistryDescriptorImpl();
		this.descriptor.setCredentials(username, password);
		this.descriptor.setUrl(SDMXRegistryInterfaceType.RESTV2_1, registryURL);
		this.conceptSchemeMap = new HashMap<>();
	}
	
	@Override
	public void initDataStructureLoader(String agency, String dsdName, String version)   throws SDMXLoaderException
	{
		this.logger.debug("Loading fusion registry");
		this.registryClient = new FusionRegistryClient(this.descriptor);
		this.logger.debug("Loading data structure from Fusion Registry");
		try
		{
			
			SdmxBeans dataStructureBeans = this.registryClient.getDataStructure(agency, dsdName, version, Detail.full, References.all);

			if (!dataStructureBeans.getDataStructures().isEmpty())
			{
				this.logger.debug("Data Structure definition found");
				this.dsd = dataStructureBeans.getDataStructures().iterator().next();
			}
			else throw new SDMXLoaderException("Unable to found data Structure");
			
		} catch (SDMXRegistryClientException e)
		{
			this.logger.error("Unable to load data from the registry");
			throw new SDMXLoaderException("Unable to load data from the registry",e);
		}

	}

	@Override
	public DataStructureBean getDataStructureDefinition() 
	{
		return this.dsd;
	}

	@Override
	public ConceptSchemeBean getAssociatedConceptScheme(String agency,CrossReferenceBean conceptReference) throws SDMXLoaderException {
		
		this.logger.debug("Associated with concept "+conceptReference.getFullId());
		String conceptSchemeId = conceptReference.getMaintainableId();
		this.logger.debug("Concept scheme id "+conceptSchemeId);
		String version = conceptReference.getVersion();
		this.logger.debug("Version "+version);
		ConceptSchemeBean conceptScheme = this.conceptSchemeMap.get(conceptSchemeId+"-"+version);
		
		if (conceptScheme == null)
		{
			this.logger.debug("Loading new concept scheme");
			
			try
			{
				SdmxBeans sdmxBeans = this.registryClient.getConceptScheme(agency, conceptSchemeId, version, Detail.full, References.none);	
				conceptScheme = sdmxBeans.getConceptSchemes().iterator().next();
				this.conceptSchemeMap.put(conceptSchemeId+"-"+version, conceptScheme);
				this.logger.debug("Concept scheme loaded");
			} catch (SDMXRegistryClientException e)
			{
				throw new SDMXLoaderException("Unable to load concept scheme",e);
			}
		}
		
		return conceptScheme;
	
	}

}
