package org.gcube.data.analysis.excel.data.impl;

import java.util.ArrayList;
import java.util.List;

import org.gcube.data.analysis.excel.data.CellWrapper;
import org.gcube.data.analysis.excel.data.TimeSeriesColumn;
import org.gcube.data.analysis.excel.data.exceptions.InvalidColumnException;

public class TimeSeriesColumnImpl implements TimeSeriesColumn
{
	
	private String name;
	private DATA_TYPE dataType;
	private ArrayList<Object> dataValues;
	
	public TimeSeriesColumnImpl (List<CellWrapper> cells) throws InvalidColumnException
	{
		if (cells == null || cells.isEmpty()) throw new InvalidColumnException("Cells list empty");
		
		else
		{
			this.dataValues = new ArrayList<>();
			this.dataType = DATA_TYPE.BLANK;
			CellWrapper headerCell = cells.remove(0);
			
			try
			{
				String headerName = (String) headerCell.getValue();
				
				if (headerName == null || headerName.trim().length() == 0) throw new InvalidColumnException("Empty header name");
				
				this.name = headerName;
				parseDataValues(cells);
				
			} catch (Exception e)
			{
				
				throw new InvalidColumnException("Invalid header name",e);
			}

		}
	}
	
	private void parseDataValues (List<CellWrapper> cells)
	{
		for (CellWrapper cell : cells)
		{
			this.dataType = this.dataType.compare(cell.getDataType());
			this.dataValues.add(cell.getValue());
		}
	}

	
//	private void parseDataValues (List<Cell> cells)
//	{
//		this.dataValues = new ArrayList<>();
//		int dataTypes = 0;
//		
//		for (Cell cell : cells)
//		{
//
//			CellType type = cell.getCellTypeEnum();
//
//			switch (type)
//			{
//			case NUMERIC:
//				dataTypes = addObjectValue(cell.getNumericCellValue(), DATA_TYPE.NUMERIC, dataTypes);
//			break;
//			case BOOLEAN:
//				dataTypes = addObjectValue(cell.getBooleanCellValue(), DATA_TYPE.GENERIC, dataTypes);
//				break;
//			case STRING:
//				dataTypes = addObjectValue(cell.getStringCellValue(), DATA_TYPE.GENERIC, dataTypes);
//				break;
//				default:
//				dataTypes = addObjectValue("", DATA_TYPE.GENERIC, dataTypes);
//			}
//		}
//			
//	}
	
//	private int addObjectValue (Object value, DATA_TYPE newDataType, int currentDataTypesNumber)
//	{
//		this.dataValues.add(value);
//		
//		if (currentDataTypesNumber == 0)
//		{
//			this.dataType = newDataType;
//			currentDataTypesNumber++;
//		}
//		else  if (newDataType != this.dataType)
//		{
//			this.dataType = DATA_TYPE.GENERIC;
//		}
//		
//		return currentDataTypesNumber;
//	}
	
	public String getName () {
		return this.name;
	}
	
	public DATA_TYPE getDataType ()
	{
		return this.dataType;
	}
	
	public List<Object> getData ()
	{
		return this.dataValues;
	}

	@Override
	public String toString() {
		StringBuilder textBulder = new StringBuilder("Column name ");
		textBulder.append(name);
		
		if (this.dataType!= null) textBulder.append(" data type ").append(this.dataType);
		
		return textBulder.toString();
	}
	

}
