package org.gcube.data.analysis.excel.data.factory;

import java.util.Iterator;
import java.util.Set;

import org.gcube.data.analysis.excel.data.TimeSeriesColumn;
import org.gcube.data.analysis.excel.data.TimeSeriesTable;
import org.gcube.data.analysis.excel.data.TimeSeriesColumn.DATA_TYPE;
import org.gcube.data.analysis.excel.data.impl.TimeSeriesTableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSeriesTableFactory 
{
	
	public static TimeSeriesTable generateTimeSeriesTable (String name, Set<TimeSeriesColumn> columns)
	{
		Logger logger = LoggerFactory.getLogger(TimeSeriesTableFactory.class);
		boolean template = true;
		Iterator<TimeSeriesColumn> columnsIterator = columns.iterator();
		
		while (columnsIterator.hasNext() && template)
		{
			template = columnsIterator.next().getDataType() == DATA_TYPE.BLANK;
		}
		logger.debug("Generated "+(template ? "template" : "table"));
		
		return new TimeSeriesTableImpl(name, columns, template);
	}

}
