package org.gcube.data.analysis.excel.data;

import java.util.List;

public interface TimeSeriesColumn 
{
	
	public enum DATA_TYPE {
		NUMERIC ,
		GENERIC ,
		TIME ,
		BLANK;
		
		public DATA_TYPE compare (DATA_TYPE other)
		{
			switch (this)
			{
			case BLANK:
				return other;
			case TIME:
			case NUMERIC:
				if (other == this) return this;
			default:
				return DATA_TYPE.GENERIC;
		
			}
			
		}
	}

	
	public String getName ();
	
	public DATA_TYPE getDataType ();
	
	public List<Object> getData ();

}
