/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.sdmx.datasource.tabman.querymanager;

import java.util.Set;
import org.gcube.datapublishing.sdmx.RegistryInformationProvider;
import org.gcube.datapublishing.sdmx.model.Registry;
import org.sdmxsource.sdmx.api.exception.CrossReferenceException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.ServiceRetrievalManager;
import org.sdmxsource.sdmx.api.model.ResolutionSettings;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.AgencyBean;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.query.RESTStructureQuery;
import org.sdmxsource.sdmx.structureretrieval.manager.DefaultServiceRetrievalManager;
import org.sdmxsource.sdmx.structureretrieval.manager.RESTSdmxBeanRetrievalManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISRESTSdmxBeanRetrievalManager
implements SdmxBeanRetrievalManager {
    private RESTSdmxBeanRetrievalManager internalBeanRetrievalManager = null;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public ISRESTSdmxBeanRetrievalManager() throws Exception {
        Registry registry = RegistryInformationProvider.getRegistry();
        if (registry == null) {
            throw new Exception("Unable to generate retrieval manager");
        }
        this.logger.debug("Using registry " + registry.getEndpoint());
        this.internalBeanRetrievalManager = new RESTSdmxBeanRetrievalManager(registry.getEndpoint());
        DefaultServiceRetrievalManager serviceRetrievalManager = new DefaultServiceRetrievalManager();
        serviceRetrievalManager.setBaseUrl(registry.getEndpoint());
        this.internalBeanRetrievalManager.setServiceRetrievalManager((ServiceRetrievalManager)serviceRetrievalManager);
        this.logger.debug("Configuration completed");
    }

    public AgencyBean getAgency(String id) {
        return this.internalBeanRetrievalManager.getAgency(id);
    }

    public IdentifiableBean getIdentifiableBean(CrossReferenceBean crossReferenceBean) throws CrossReferenceException {
        return this.internalBeanRetrievalManager.getIdentifiableBean(crossReferenceBean);
    }

    public Set<? extends IdentifiableBean> getIdentifiableBeans(StructureReferenceBean sRef) {
        return this.internalBeanRetrievalManager.getIdentifiableBeans(sRef);
    }

    public <T> T getIdentifiableBean(CrossReferenceBean crossReferenceBean, Class<T> structureType) throws CrossReferenceException {
        return (T)this.internalBeanRetrievalManager.getIdentifiableBean(crossReferenceBean, structureType);
    }

    public <T> T getIdentifiableBean(StructureReferenceBean crossReferenceBean, Class<T> structureType) throws CrossReferenceException {
        return (T)this.internalBeanRetrievalManager.getIdentifiableBean(crossReferenceBean, structureType);
    }

    public SdmxBeans getMaintainables(RESTStructureQuery restquery) {
        return this.internalBeanRetrievalManager.getMaintainables(restquery);
    }

    public SdmxBeans getSdmxBeans(StructureReferenceBean sRef, ResolutionSettings.RESOLVE_CROSS_REFERENCES resolveCrossReferences) {
        return this.internalBeanRetrievalManager.getSdmxBeans(sRef, resolveCrossReferences);
    }

    public MaintainableBean getMaintainableBean(StructureReferenceBean sRef) {
        return this.internalBeanRetrievalManager.getMaintainableBean(sRef);
    }

    public MaintainableBean getMaintainableBean(StructureReferenceBean sRef, boolean returnStub, boolean returnLatest) {
        return this.internalBeanRetrievalManager.getMaintainableBean(sRef, returnStub, returnLatest);
    }

    public <T extends MaintainableBean> T getMaintainableBean(Class<T> structureType, MaintainableRefBean ref) {
        return (T)this.internalBeanRetrievalManager.getMaintainableBean(structureType, ref);
    }

    public <T extends MaintainableBean> T getMaintainableBean(Class<T> structureType, MaintainableRefBean ref, boolean returnStub, boolean returnLatest) {
        return (T)this.internalBeanRetrievalManager.getMaintainableBean(structureType, ref, returnStub, returnLatest);
    }

    public <T extends MaintainableBean> Set<T> getMaintainableBeans(Class<T> structureType) {
        return this.internalBeanRetrievalManager.getMaintainableBeans(structureType);
    }

    public <T extends MaintainableBean> Set<T> getMaintainableBeans(Class<T> structureType, MaintainableRefBean ref) {
        return this.internalBeanRetrievalManager.getMaintainableBeans(structureType, ref);
    }

    public <T extends MaintainableBean> Set<T> getMaintainableBeans(Class<T> structureType, MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        return this.internalBeanRetrievalManager.getMaintainableBeans(structureType, ref);
    }
}

