/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.rconnector;

import java.io.File;
import java.io.FileWriter;
import javax.inject.Singleton;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.rconnector.Info;
import org.gcube.data.analysis.rconnector.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConfigFileWriter {
    private static final Logger log = LoggerFactory.getLogger(ConfigFileWriter.class);

    public boolean write(Info info, String login, String fileName, String configFilePath, String scriptToExecute) {
        File userDir;
        if (!configFilePath.endsWith("/")) {
            configFilePath = configFilePath + "/";
        }
        if (!(userDir = new File(configFilePath + login)).exists()) {
            userDir.mkdir();
        }
        File configFile = new File(userDir, fileName);
        Utils.executeCommandLine((String[])new String[]{scriptToExecute, login, SecurityTokenProvider.instance.get(), ScopeProvider.instance.get()});
        return this.writeFile(info, configFile);
    }

    private boolean writeFile(Info info, File pathToFile) {
        log.debug("writing config file");
        StringBuffer sb = new StringBuffer();
        sb.append(info.getTableName() + ";");
        sb.append(info.getUserTableName() + ";");
        sb.append(info.getFields());
        if (!info.getFields().endsWith(";")) {
            sb.append(";");
        }
        sb.append(info.getQueryColumns());
        if (!info.getQueryColumns().endsWith(";")) {
            sb.append(";");
        }
        sb.append(info.getDatabase().getDatabaseAddress() + ";");
        sb.append(info.getDatabase().getDatabaseName() + ";");
        sb.append(info.getDatabase().getDatabaseUsername() + ";");
        sb.append(info.getDatabase().getDatabasePassword() + ";");
        sb.append(info.getUsername() + ";");
        sb.append(info.getToken() + "\n");
        try (FileWriter fw = new FileWriter(pathToFile, false);){
            fw.write(sb.toString());
        }
        catch (Exception e) {
            log.error("error writing config file", (Throwable)e);
            return false;
        }
        log.debug("file written with line {}", (Object)sb.toString());
        return true;
    }
}

