/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.rconnector;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.inject.Singleton;
import org.gcube.data.analysis.rconnector.Info;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConfigFileWriter {
    private static Logger log = LoggerFactory.getLogger(ConfigFileWriter.class);

    public boolean write(Info info, String login, String usersHome, String fileName, String scriptToExecute) {
        if (!usersHome.endsWith("/")) {
            usersHome = String.valueOf(usersHome) + "/";
        }
        File userDir = new File(String.valueOf(usersHome) + login);
        File configFile = new File(userDir, fileName);
        this.executeCommandLine(scriptToExecute, login);
        return this.writeFile(info, configFile);
    }

    private String executeCommandLine(String cmd, String login) {
        log.debug("executing command " + cmd + " " + login);
        Process process = null;
        String lastline = "";
        try {
            ProcessBuilder pb = new ProcessBuilder(cmd, login);
            process = pb.start();
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                log.warn("interrupt Exception on process", (Throwable)e);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String line = br.readLine();
            while (line != null) {
                lastline = String.valueOf(lastline) + line;
                line = br.readLine();
            }
        }
        catch (IOException e) {
            log.error("error executing command line", (Throwable)e);
        }
        log.debug("command result line is " + lastline);
        return lastline;
    }

    private boolean writeFile(Info info, File pathToFile) {
        log.debug("writing config file");
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(info.getTableName()) + ";");
        sb.append(String.valueOf(info.getUserTableName()) + ";");
        sb.append(info.getFields());
        if (!info.getFields().endsWith(";")) {
            sb.append(";");
        }
        sb.append(info.getQueryColumns());
        if (!info.getQueryColumns().endsWith(";")) {
            sb.append(";");
        }
        sb.append(String.valueOf(info.getDatabase().getDatabaseAddress()) + ";");
        sb.append(String.valueOf(info.getDatabase().getDatabaseName()) + ";");
        sb.append(String.valueOf(info.getDatabase().getDatabaseUsername()) + ";");
        sb.append(String.valueOf(info.getDatabase().getDatabasePassword()) + ";");
        sb.append(String.valueOf(info.getUsername()) + ";");
        sb.append(String.valueOf(info.getToken()) + "\n");
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileWriter fw = new FileWriter(pathToFile, false);){
                fw.write(sb.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error("error writing config file", (Throwable)e);
            return false;
        }
        log.debug("file written with line {}", (Object)sb.toString());
        return true;
    }
}

