/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.rconnector;

import java.io.File;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.rconnector.ConfigFileWriter;
import org.gcube.data.analysis.rconnector.Info;
import org.gcube.data.analysis.rconnector.InfoRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="connect/")
public class Resource {
    private static final Logger log = LoggerFactory.getLogger(Resource.class);
    @Inject
    ConfigFileWriter writer;
    @Inject
    InfoRetriever infoRetriever;
    @Context
    ServletContext context;

    @Path(value="/{trId}")
    @GET
    public Response connect(@PathParam(value="trId") Long tabularResourceId) {
        Info info;
        log.info("connect called with user {} and trID {} in scope {}", new Object[]{AuthorizationProvider.instance.get().getClient().getId(), tabularResourceId, ScopeProvider.instance.get()});
        String usersHome = this.context.getInitParameter("usersHome");
        String filename = this.context.getInitParameter("filename");
        String scriptToExecute = this.context.getInitParameter("addUserScript");
        if (ScopeProvider.instance.get() == null || AuthorizationProvider.instance.get().getClient().getId() == null || tabularResourceId == null) {
            return Response.serverError().build();
        }
        try {
            info = this.infoRetriever.retrieve(AuthorizationProvider.instance.get().getClient().getId(), tabularResourceId);
            log.debug("retrieved info: " + info);
        }
        catch (Exception e) {
            log.error("error connecting to r", (Throwable)e);
            return Response.serverError().build();
        }
        if (!this.writer.write(info, AuthorizationProvider.instance.get().getClient().getId(), usersHome, filename, scriptToExecute)) {
            return Response.serverError().build();
        }
        return this.createResponse(AuthorizationProvider.instance.get().getClient().getId());
    }

    @GET
    public Response connect() {
        log.info("connect called with user {} in scope {}", (Object)AuthorizationProvider.instance.get().getClient().getId(), (Object)ScopeProvider.instance.get());
        String usersHome = this.context.getInitParameter("usersHome");
        String filename = this.context.getInitParameter("filename");
        String scriptToExecute = this.context.getInitParameter("addUserScript");
        if (AuthorizationProvider.instance.get().getClient().getId() == null) {
            return Response.serverError().build();
        }
        Info info = new Info();
        info.setUsername(AuthorizationProvider.instance.get().getClient().getId());
        info.setToken(SecurityTokenProvider.instance.get());
        if (!this.writer.write(info, AuthorizationProvider.instance.get().getClient().getId(), usersHome, filename, scriptToExecute)) {
            return Response.serverError().build();
        }
        return this.createResponse(AuthorizationProvider.instance.get().getClient().getId());
    }

    private Response createResponse(String userName) {
        try {
            String keyFilePath = this.context.getInitParameter("storedKeyPath");
            String rStudioServerAddress = this.context.getInitParameter("rStudioAddress");
            log.debug("key file path: " + keyFilePath);
            log.debug("rstudio server address: " + rStudioServerAddress);
            Calendar now = Calendar.getInstance();
            now.add(1, 10);
            now.add(6, -1);
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
            String format = sdf.format(now.getTime());
            File keyFile = new File(keyFilePath);
            if (!keyFile.exists()) {
                return Response.serverError().build();
            }
            byte[] keyByte = Files.readAllBytes(keyFile.toPath());
            SecretKeySpec keySpec = new SecretKeySpec(keyByte, "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(keySpec);
            byte[] result = mac.doFinal((userName + format).getBytes());
            String encoded = URLEncoder.encode(DatatypeConverter.printBase64Binary((byte[])result));
            String cookieValue = userName + "|" + URLEncoder.encode(format).replaceAll("\\+", "%20") + "|" + encoded;
            NewCookie cookie = new NewCookie("user-id", cookieValue, "/", rStudioServerAddress, "", -1, false, true);
            return Response.seeOther((URI)new URI("http://" + rStudioServerAddress)).cookie(new NewCookie[]{cookie}).build();
        }
        catch (Exception e) {
            log.error("error creating response", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

