/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.rconnector;

import java.io.File;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.rconnector.ConfigFileWriter;
import org.gcube.data.analysis.rconnector.Info;
import org.gcube.data.analysis.rconnector.InfoRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="connect/{user}/{trId}")
public class Resource {
    private static final Logger log = LoggerFactory.getLogger(Resource.class);
    @Inject
    ConfigFileWriter writer;
    @Inject
    InfoRetriever infoRetriever;
    @Context
    ServletContext context;

    @GET
    public Response connect(@NotNull @PathParam(value="user") String userName, @NotNull @PathParam(value="trId") Long tabularResourceId, @QueryParam(value="scope") String scope) {
        Info info;
        log.info("connect called with user {} and trID {} in scope {}", new Object[]{userName, tabularResourceId, scope});
        String usersHome = this.context.getInitParameter("usersHome");
        String filename = this.context.getInitParameter("filename");
        String scriptToExecute = this.context.getInitParameter("addUserScript");
        if (scope == null || userName == null || tabularResourceId == null) {
            return Response.serverError().build();
        }
        ScopeProvider.instance.set(scope);
        try {
            info = this.infoRetriever.retrieve(userName, tabularResourceId);
            log.debug("retrieved info: " + info);
        }
        catch (Exception e) {
            log.error("error connecting to r", (Throwable)e);
            return Response.serverError().build();
        }
        if (!this.writer.write(info, userName, usersHome, filename, scriptToExecute)) {
            return Response.serverError().build();
        }
        return this.createResponse(userName);
    }

    private Response createResponse(String userName) {
        try {
            String keyFilePath = this.context.getInitParameter("storedKeyPath");
            String rStudioServerAddress = this.context.getInitParameter("rStudioAddress");
            log.debug("key file path: " + keyFilePath);
            log.debug("rstudio server address: " + rStudioServerAddress);
            Calendar now = Calendar.getInstance();
            now.add(1, 10);
            now.add(6, -1);
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
            String format = sdf.format(now.getTime());
            File keyFile = new File(keyFilePath);
            if (!keyFile.exists()) {
                return Response.serverError().build();
            }
            byte[] keyByte = Files.readAllBytes(keyFile.toPath());
            SecretKeySpec keySpec = new SecretKeySpec(keyByte, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(keySpec);
            byte[] result = mac.doFinal((userName + format).getBytes());
            String encoded = URLEncoder.encode(DatatypeConverter.printBase64Binary((byte[])result));
            String cookieValue = userName + "|" + URLEncoder.encode(format).replaceAll("\\+", "%20") + "|" + encoded;
            NewCookie cookie = new NewCookie("user-id", cookieValue, "/", rStudioServerAddress, "", -1, false, true);
            return Response.seeOther((URI)new URI("http://" + rStudioServerAddress)).cookie(new NewCookie[]{cookie}).build();
        }
        catch (Exception e) {
            log.error("error creating response", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

