/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.rconnector;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.inject.Singleton;
import org.gcube.data.analysis.rconnector.Info;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConfigFileWriter {
    private static final Logger log = LoggerFactory.getLogger(ConfigFileWriter.class);

    public boolean write(Info info, String login, String usersHome, String fileName, String scriptToExecute) {
        if (!usersHome.endsWith("/")) {
            usersHome = usersHome + "/";
        }
        File userDir = new File(usersHome + login);
        File configFile = new File(userDir, fileName);
        this.checkDirectory(userDir, login, scriptToExecute);
        return this.writeFile(info, configFile);
    }

    private void checkDirectory(File userDir, String login, String scriptToExecute) {
        if (!userDir.isDirectory() || !userDir.exists()) {
            this.executeCommandLine(scriptToExecute, login);
        }
    }

    private String executeCommandLine(String cmd, String login) {
        log.debug("executing command " + cmd + " " + login);
        Process process = null;
        String lastline = "";
        try {
            ProcessBuilder pb = new ProcessBuilder(cmd, login);
            process = pb.start();
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                log.warn("interrupt Exception on process", (Throwable)e);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String line = br.readLine();
            while (line != null) {
                lastline = lastline + line;
                line = br.readLine();
            }
        }
        catch (IOException e) {
            log.error("error executing command line", (Throwable)e);
        }
        log.debug("command result line is " + lastline);
        return lastline;
    }

    private boolean writeFile(Info info, File pathToFile) {
        log.debug("writing config file");
        StringBuffer sb = new StringBuffer();
        sb.append(info.getTableName() + ";");
        sb.append(info.getUserTableName() + ";");
        sb.append(info.getFields());
        if (!info.getFields().endsWith(";")) {
            sb.append(";");
        }
        sb.append(info.getQueryColumns());
        if (!info.getQueryColumns().endsWith(";")) {
            sb.append(";");
        }
        sb.append(info.getDatabase().getDatabaseAddress() + ";");
        sb.append(info.getDatabase().getDatabaseName() + ";");
        sb.append(info.getDatabase().getDatabaseUsername() + ";");
        sb.append(info.getDatabase().getDatabasePassword() + "\n");
        try {
            FileWriter fw = new FileWriter(pathToFile, false);
            fw.write(sb.toString());
            fw.close();
            log.debug("file written");
        }
        catch (Exception e) {
            log.error("error writing config file", (Throwable)e);
            return false;
        }
        return true;
    }
}

